

; k7p7alt.asm Mega8 ersetzt zwei 74LS47 mit Hexaziffern
; Port B: PB0 - PB6 Siebensegmentausgnge links  PB7 frei fr Eingabe 
; Port C: PC0 - PC5 Siebensegmentausgnge rechts
; Port D: BCD Eingnge fr Port B und Port C
; Fuses: Int. RC Osc. 1 MHz PB6 und PB7 als Port 
; Fuses: Reset Diabled (Enable PC6 as i/opin) Parallel Progr. STK500 
        .INCLUDE    "m8def.inc"     ; Deklarationen fr Mega8
        .CSEG                       ; Programm-Flash
        rjmp        start           ; Reset-Einsprung
        .ORG        $13             ; Interrupteinsprnge bergehen
start:  ldi         r16,LOW(RAMEND) ; Stapel anlegen
        out         SPL,r16         ;
        ldi         r16,HIGH(RAMEND); 
        out         SPH,r16         ;
        ldi         r16,$7F         ; 0111 1111 
        out         DDRB,r16        ; PB0 - PB6 sind Ausgnge
        out         DDRC,r16        ; PC0 - PC6 sind Ausgnge
loop:   in          r16,PIND        ; R16 <- zwei BCD-Eingnge
        mov         r17,r16         ; R17 <- retten
        ldi         ZL,LOW(tab*2)   ; Z <- Tabellenadresse
        ldi         ZH,HIGH(tab*2)  ;
        andi        r16,$0F         ; Maske 0000 1111 rechts frei
        add         ZL,r16          ; Z <- Z + Abstand
        clr         r16             ;
        adc         ZH,r16          ;
        lpm                         ; R0 <- (Z) Tabellenzugriff
        mov         r16,r0          ; R16 <- Code Low
        ldi         ZL,LOW(tab*2)   ; Z <- Tabellenadresse
        ldi         ZH,HIGH(tab*2)  ;
        swap        r17             ; R17 Hlften vertauschen
        andi        r17,$0F         ; Maske 0000 1111 rechts frei
        add         ZL,r17          ; Z <- Z + Abstand
        clr         r17             ;
        adc         ZH,r17          ;
        lpm                         ; R0 <- (Z) Tabellenzugriff
        mov         r17,r0          ; R17 <- Code High
        out         PORTB,r0        ; nach Anzeige links
        out         PORTC,r16       ; nach Anzeige rechts
        rjmp        loop            ;
; Codetabelle fr Ziffern 0 - 9 und A b C d E F fr gemeinsame Anode !!!
tab:    .DB         $40,$79,$24,$30,$19,$12,$02,$78,$00,$18,$08,$03,$46,$21,$06,$0E
        .EXIT                       ; Ende des Programmsegments