

; k6p9.asm  ATmega8  Tongenerator  Frequenz mit Poti einstellen
; Port B: Ausgang PB1  OC1A Signalausgabe B7-B4 Ladewert Hunderter
; Port C: Eingang ADC0 Poti fr Frequenzeinstellung
; Port D: Ausgang Zehner : Einer des Ladewerts
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister R17 R18 frei
        .DEF    zael = r19      ; Zhler fr Mittelwert
        .DEF    summlo = r20    ; Summe Low
        .DEF    summi  = r21    ; Summe Middle
        .DEF    summhi = r22    ; Summe High
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ;
        out     DDRD,akku       ; Port D ist Ausgang
        out     DDRB,akku       ; Port B PB1 ist Ausgang OC1A
; AD-Wandler programmieren
        ldi     akku,(0 << REFS1) | (1 << REFS0) | (0 << ADLAR) ; 
        out     ADMUX,akku       ; Referenz AVCC, rechtsbndig, Kanal PC0
        ldi     akku,(1 << ADEN) | (1 << ADSC) | (1 << ADPS1) | (1 << ADPS0);
        out     ADCSRA,akku      ; Wandler ein und starten, Einzel, Teiler 8
; Timer1: programmieren 
        ldi     akku,(1 << COM1A0) ; OC1A umschalten
        out     TCCR1A,akku     ; Steuerregister A Timer1
        ldi     akku,0b001      ; Taktteiler :1
        ori     akku,(1 << WGM12) ; Timer1 nach match lschen
        out     TCCR1B,akku     ; Steuerregister B Timer1 start
neu:    clr     summlo          ; Summe lschen
        clr     summi           ;
        clr     summhi          ;
        clr     zael            ; Zhler fr 256 Messwerte
; Arbeitsschleife Compare A Register laden Mittel aus 256 Messwerten
loop:   sbic    ADCSRA,ADSC     ; berspringe wenn Wandlung beendet
        rjmp    loop            ; warte auf Ende der Wandlung
        in      akku,ADCL       ; erst Low laden
        add     summlo,akku     ;   
        in      akku,ADCH       ; dann High laden
        adc     summi,akku      ;
        clr     akku            ;
        adc     summhi,akku     ;
        dec     zael            ; Zhler vermindern
        brne    loop1           ; noch kein Ende
; Mittel aus 256 Messungen ausgeben
        out     OCR1AH,summhi   ; erst High
        out     OCR1AL,summi    ; dann Low    summlo verwerfen
        mov     r17,summhi      ;
        mov     r16,summi       ; R17:R16 = Ladewert dual
        rcall   dual4bcd        ; nach R18:R17:R16 BCD
        out     PORTD,r16       ; Ladewert Zehner | Einer
        swap    r17             ; Hunderter nach vorn
        andi    r17,0b11110000  ; Tausender maskieren
        out     PORTB,r17       ; Ladewert Hunderter
        sbi     ADCSRA,ADSC     ; Wandler neu starten
        rjmp    neu             ; Summe und Zhler lschen
loop1:  sbi     ADCSRA,ADSC     ; Wandler neu starten
        rjmp loop               ;
       .INCLUDE "dual4bcd.asm"  ; R17:R16 dual -> R18:R17:R16 BCD
       .EXIT                    ; Ende des Quelltextes





