


; k6p5.asm  ATmega8 LCD-Anzeige und Test der PC-Tastatur
; Port B: LCD-Anzeige: PB1: E-Signal
; Port B: PC-Tastatur: PB5: Takt  PB3: Daten
; Port D: LCD-Anzeige: PD7 PD6 PD5 PD4 (4bit)   PD3: RS-Signal
        .INCLUDE "m8def.inc"    ; Deklarationen fr ATmega8
        .EQU    takt = 8000000  ; Systemtakt Quarz 8 MHz
; Symboldefinitionen fr LCD-Schnittstelle 4bit Bus an High-Port
        .EQU    lcdpen = PORTB  ; Port des E-Signals
        .EQU    lcden = PB1     ; Bit E Freigabsignal 
        .EQU    lcdprs = PORTD  ; Port des RS-Signal
        .EQU    lcdrs = PD3     ; Bit RS Registerauswahlsignal
        .EQU    lcdpdat = PORTD ; Port des 4bit-Datenbus
        .EQU    lcdbus = 'h'    ; Anschluss an High-Port PB7..PB4
; Registerdefinitionen
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    curpos = r23    ; R23 = laufende Cursorposition
        .DEF    zustand = r24   ; R24 = Tastaturzustand
        .CSEG                   ; Programm-Flash
         rjmp    start          ; Reset-Einsprung
        .ORG    $13             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapelzeiger
        out     SPL,akku        ; anlegen
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku        ;
        ldi     akku,0b11111000 ; PD7-PD3 sind Ausgnge
        out     DDRD,akku       ; fr LCD und Tastaturspalten
        cbi     PORTB,lcden     ; PB1 Ausgang low
        sbi     DDRB,lcden      ; PB1 ist Ausgang fr LCD-/E-Signal
        rcall   lcd4ini         ; LCD initialisieren
        clr     curpos          ; Cursor links oben
        clr     zustand         ; Tastaturzustand gross
; Testschleife fr Tasten
loop:   rcall   pctast          ; R16 <- ASCII-Code  R17 <- Scancode
        mov     r18,r16         ; R18 <- ASCII-Code retten
        mov     r16,r17         ; R16 <- Scancode 
        rcall   aushex8         ; lz $ und Scancode hexadezimal
        ldi     r16,' '         ; lz
        rcall   lcd4put         ; ausgeben
        mov     r16,r18         ; R16 <- ASCII-Code
        tst     r16             ; R16 = $00 ?
        breq    loop1           ; ja. Code nicht belegt
        rcall   lcd4put         ; nein: ASCII-Code ausgeben
        ldi     r16,' '         ; lz
        rcall   lcd4put         ; ausgeben
        rcall   lcd4put         ;
        rjmp    loop            ; neue Eingabe
; ASCII-Code nicht belegt 
loop1:  ldi     r16,$40         ; @ ausgeben
        rcall   lcd4put         ;
        ldi     r16,' '         ; Leerzeichen
        rcall   lcd4put         ;
        rcall   lcd4put         ; 
        rjmp    loop            ; 
;
; Externe LCD- und Tastatur-Unterprogramme
       .INCLUDE "lcd4.h"         ; warte1ms und lcd4-Unterprogramme
       .INCLUDE "pctast.asm"     ; R16 <- Tastencode PC-Tastatur
       .INCLUDE "aushex8.asm"    ; R16 hexa ausgeben  ruft putch
putch:  rcall    lcd4put         ; Umleitung nach LCD-Ausgabe
        ret                      ; 
       .EXIT                     ; Ende des Quelltextes

