

; k6p3.asm  LED-Matrix mit ATtiny2313
; Port B: B0..B3 Ausgnge Spaltenauswahl    B4: Eingang Rcksetzen
; Port D: D0..D6 Ausgnge fr Anzeigecode der Zeilen
        .INCLUDE "tn2313def.inc"; Deklarationen fr Tiny2313
        .EQU    takt = 3686400  ; externer Systemtakt Quarz 3.6864 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    hilfe = r17     ; Hilfsregister
        .DEF    spalte = r18    ; laufende Ausgabespalte
        .DEF    null = r19      ; Nullregister
        .DEF    sek = r20       ; laufender Sekundenzhler
        .DEF    zaehl = r21     ; Interruptzhler Timer0 Uhr
        .CSEG                   ; Programmsegment
        rjmp    start           ; Reset-Einsprung
        .ORG    OVF1addr        ; Einsprung Timer1 berlauf
        rjmp    muxen           ; alle 0.556 ms neue Spalte ausgeben
        .ORG    OVF0addr        ; Einsprung Timer0 berlauf
        rjmp    uhr             ; jede Sekunde Uhr + 1 
        .ORG    $13             ; Interrupteinsprnge bergangen
start:  ldi     akku,LOW(RAMEND); Endadresse des SRAM
        out     SPL,akku        ; Stapelzeiger_Low
        clr     null            ; Nullregister lschen
        ldi     akku,$0f        ; 0000 1111 PB0..PB3 Ausgnge
        out     DDRB,akku       ; Richtung Port B
        ldi     akku,$ff        ; 1111 1111 PD0..PD7 Ausgnge
        out     DDRD,akku       ; Richtung Port D 
        ldi     zaehl,225       ; Anfangswert Uhreninterrupt
        clr     spalte          ; Spalte 0 beginnt
        clr     sek             ; Sekundenzhler lschen
        mov     akku,sek        ; Anfangswert
        rcall   ausgabe         ; nach Ausgabespeicher
; Timer0 und Timer1 programmieren und starten        
        ldi     akku,0b011      ; 3.6864 MHz : 64 : 256 = 225 Hz 
        out     TCCR0B,akku     ; Timer0 starten
        in      akku,TIMSK      ; alte Interruptmasken
        ori     akku,1 << TOIE0 ; Freigabe Timer0 Interrupt
        out     TIMSK,akku      ; 
        in      akku,TIMSK      ; alte Interruptmasken
        ori     akku,1 << TOIE1 ; Freigabe Timer1 Interrupt
        out     TIMSK,akku      ; 
        ldi     akku,HIGH(65536-3686) ;
        out     TCNT1H,akku     ;
        ldi     akku,LOW(65536-3686)  ;
        out     TCNT1L,akku     ;
        ldi     akku,0b001      ; 3.6864 MHz : 1 : 3686 = 1 kHz
        out     TCCR1B,akku     ; Timer1 starten   
        sei                     ; alle Interrupts frei
haupt:  sbic    PINB,PINB4      ; berspringe wenn Lschtaste Low
        rjmp    haupt           ; bei High weiter
        clr     sek             ; fallende Flanke: Sekunde lschen
        mov     akku,sek        ;
        rcall   ausgabe         ; und ausgeben
haupt1: sbis    PINB,PINB4      ; steigende Flanke: weiter
        rjmp    haupt1          ; 
        rjmp    haupt           ; Hauptprogrammschleife
; 
; ausgabe: R16 von dual nach dezimal umwandeln und ausgeben 
ausgabe:push    r16             ; Register retten
        push    r17             ;
        push    r18             ;
        push    XH              ; Zeiger auf Ausgabespeicher
        push    XL              ;
        push    ZH              ; Zeiger auf Codekonstanten
        push    ZL              ;
        ldi     XH,HIGH(aus)    ; X <= Anfangsadresse Ausgabe
        ldi     XL,LOW(aus)     ;
; Hunderter-Ziffer umwandeln
        clr     r17             ; R17 = Hunderterzhler
ausgab1:cpi     r16,100         ; Hunderterprobe
        brlo    ausgab2         ; < 100: fertig
        subi    r16,100         ; abziehen
        inc     r17             ; Hunderter + 1
        rjmp    ausgab1         ;
ausgab2:mov     r18,r17         ; R18 = Hunderter fr fhrende Nullen
        cpi     r17,0           ; fhrende Null ?
        brne    ausgab3         ; nein: Ziffer ausgeben
        ldi     r17,10          ; Code fr Leerzeichen
ausgab3:rcall   umcode          ; Hunderter R17 umcodieren und ausgeben
        clr     r17             ;
ausgab4:cpi     r16,10          ; Zehnerprobe
        brlo    ausgab5         ; < 10: fertig
        subi    r16,10          ; abziehen
        inc     r17             ; Zehner + 1
        rjmp    ausgab4         ;
ausgab5:or      r18,r17         ; zwei fhrende Nullen ?  
        brne    ausgab6         ; nein:
        ldi     r17,10          ; ja: auch Zehner durch Leerzeichen ersetzen  
ausgab6:rcall   umcode          ; Zehner R17 umcodieren und ausgeben
        mov     r17,r16         ; R16 Rest Einer -> R17 
        rcall   umcode          ; Einer R17 umcodieren und ausgeben 
        pop     ZL              ; Register zurck
        pop     ZH              ;
        pop     XL              ;
        pop     XH              ;
        pop     r18             ;
        pop     r17             ; 
        pop     r16             ;
        ret                     ; Rcksprung  
; Hilfsunterprogramm Ziffer aus R17 umcodieren und nach Ausgabe
umcode: push    r17             ; Register retten
        push    r18             ;
        push    ZL              ;
        push    ZH              ; 
        mov     r18,r17         ; Ziffer retten
        lsl     r17             ; Ziffer * 2
        lsl     r17             ; Ziffer * 4
        add     r17,r18         ; Ziffer * 5
        ldi     ZH,HIGH(code*2) ; Z <= Anfangsadresse Codetabelle
        ldi     ZL,LOW(code*2)  ;
        add     ZL,r17          ; + Ziffernabstand
        adc     ZH,null         ; 
; Ausgabeschleife
        ldi     r18,5           ; 5 Spalten kopieren
umcode1:lpm                     ; R0 <= Tabellenwert
        adiw    ZL,1            ; nchster Tabellenwert 
        st      X+,r0           ; nach Ausgabespeicher Adresse + 1
        dec     r18             ; Durchlaufzhler - 1
        brne    umcode1         ;
        pop     ZH              ; Register zurck
        pop     ZL              ;
        pop     r18             ;
        pop     r17             ; 
        ret                     ; Rcksprung
;
; Konstantenbereich mit Zifferncode
code:   .DB     $3E,$41,$41,$3e,$0, $00,$10,$20,$7f,$0  ; Ziffern 0 und 1
        .DB     $22,$45,$49,$31,$0, $2a,$49,$49,$36,$0  ; Ziffern 2 und 3
        .DB     $78,$08,$1f,$08,$0, $71,$49,$4a,$0c,$0  ; Ziffern 4 und 5
        .DB     $3e,$49,$49,$06,$0, $43,$44,$48,$30,$0  ; Ziffern 6 und 7
        .DB     $3e,$49,$49,$3e,$0, $32,$49,$49,$3e,$0  ; Ziffern 8 und 9 
        .DB     $00,$00,$00,$00,$00,$00                 ; Code 10 = Lz   
;               
; Interrupteinsprung Timer1 berlauf Multiplexausgabe
muxen:  push    r16             ; Register retten
        in      r16,SREG        ;
        push    r16             ;
        push    XL              ;
        push    XH              ;
        ldi     XL,LOW(aus)     ; X <= Zeiger auf Ausgabespeicher
        ldi     XH,HIGH(aus)    ;
        add     XL,spalte       ; addiere Spaltenabstand
        adc     XH,null         ; + Null + Carry
        ld      r16,X           ; lade Ausgabebyte
        out     PORTB,spalte    ; nach Spaltenauswahl
        out     PORTD,akku      ; Spalte ausgeben
        inc     spalte          ; neue Spalte
        cpi     spalte,15       ; Ende erreicht ?
        brlo    muxen1          ; nein: Spalten 0..14
        clr     spalte          ;   ja: wieder links beginnen
muxen1: ldi     r16,HIGH(65536-3686) ; Timer1 neu laden
        out     TCNT1H,r16      ;
        ldi     r16,LOW(65536-3686)  ;
        out     TCNT1L,r16      ;
        pop     XH              ; Register zurck
        pop     XL              ; 
        pop     r16             ; 
        out     SREG,r16        ;
        pop     r16             ; 
        reti                    ; Rcksprung aus Service
;        
; Interrupteinsprung Timer0 berlauf Sekundenzhler alle 225 Interrupts
uhr:    push    r16             ; Register retten
        in      r16,SREG        ;
        push    r16             ;
        dec     zaehl           ; Interruptzhler - 1 
        brne    uhr1            ;
        ldi     zaehl,225       ; 
        inc     sek             ; Sekundenzhler erhhen
        mov     r16,sek         ; aus R16
        rcall   ausgabe         ; dezimal ausgeben 
uhr1:   pop     r16             ; Register zurck
        out     SREG,r16        ;
        pop     r16             ;
        reti                    ; Rcksprung aus Service  
;
; Datenbereich fr Anzeige
        .DSEG                   ; Datensegment
aus:    .BYTE   15              ; 15 Bytes fr Anzeige
        .EXIT                   ; Ende des Quelltextes
