

; k6p11.asm  ATmega8  Servomotor  Steuerung 
; Port B: Ausgabe Pulsdauer dual Low-Byte
; Port C: Ausgabe Pulsdauer dual High-Byte
; Port D: PD2=INT0  PD3=INT1    PD0 = Ausgang Steuersignal
; Konfiguration: interner Takt 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern
        .EQU    schritt = 1     ; Schrittweite
        .DEF    akku = r16      ; Arbeitsregister 
        rjmp    start           ; Reset-Einsprung
        .CSEG                   ; Programm-Flash
        .ORG    INT0addr        ; fallende Flanke INT0
        rjmp    plus            ; 
        .ORG    INT1addr        ; fallende Flanke INT1
        rjmp    minus
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        sbi     DDRD,PD0        ; PD0 ist Ausgang 
        ldi     akku,$ff        ;
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
; Interrupts freigeben
        ldi     akku,0b00001010 ;
        out     MCUCR,akku      ;
        ldi     akku,0b11000000 ;
        out     GICR,akku       ;
        sei                     ; 
        ldi     r24,LOW(200)    ; High-Zeit vorladen
        ldi     r25,HIGH(200)   ;
        ldi     YL,LOW(3800)    ; Low-Zeit vorladen
        ldi     YH,HIGH(3800)   ;
; Arbeitsschleife
loop:   movw    XL,r24          ; High-Zeit laden
        sbi     PORTD,PD0       ; Ausgang High
        cli                     ; Interrupts sperren
loop1:  nop                     ; 1 Takt 
        sbiw    XL,1            ; 2 Takte
        brne    loop1           ; 2 Takte
        sei                     ; Interrupts frei
        out     PORTC,r25       ; High-Zeit 
        out     PORTB,r24       ; dual ausgeben
        movw    ZL,YL           ; Low-Zeit laden
        cbi     PORTD,PD0       ; Ausgang Low
loop2:  nop                     ; 1 Takt
        sbiw    ZL,1            ; 2 Takte
        brne    loop2           ; 2 Takte
        rjmp    loop            ; Schleife
; Interrupt-Service-Routinen
plus:   in      r16,SREG        ; Status retten
        adiw    r24,schritt     ; + Schrittweite
        sbiw    YL,schritt      ; - Schrittweite
        out     SREG,r16        ; Status zurck
        reti                    ; 
;
minus:  in      r16,SREG        ; Status retten
        sbiw    r24,schritt     ; - Schrittweite
        adiw    YL,schritt      ; + Schrittweite
        out     SREG,r16        ; Status zurck
        reti                    ;
       .EXIT                    ; Ende des Quelltextes


