

; k4p6.asm  ATmega8  Timer1: Flankenzhler  Timer0: Zeitbasis
; Port B: Ausgabe                       Zehner  Einer
; Port C: Ausgabe  Tausender Hunderter
; Port D: Eingang  T1 = PD5 Messfrequenz
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .EQU    durch = 125     ; 1 MHz :64 = 15625 Hz Timertakt
        .EQU    lade = 125      ; lade * durch = 125 * 125 = 15625 
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    zaehl = r19     ; Durchlaufzhler
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    OVF0addr        ; Einsprung Timer0 berlauf
        rjmp    tic             ; Timer0 Interrupt-Service
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Ausgang
        out     DDRB,akku       ; Port B Ausgang
        out     DDRC,akku       ; Port C Ausgang
        ldi     akku,$C2        ; kalibrieren
        out     OSCCAL,akku     ; RC Oszillator
        ldi     zaehl,durch     ; Durchlaufzhler Anfangswert
; Timer0: Zeitbasis 1 sek  Timer1: Flankenzhler programmieren 
        ldi     akku,-lade      ; Timer0 laden
        out     TCNT0,akku      ; 
        ldi     akku,0b011      ; Systemtakt :64 = 15.625 kHz 
        out     TCCR0,akku      ; Steuerregister Timer0 
        ldi     akku,0b110      ; externer Takt T1 PD5
        out     TCCR1B,akku     ; Steuerregister Timer1
        clr     akku            ; Flankenzhler 
        out     TCNT1H,akku     ; High lschen
        out     TCNT1L,akku     ; Low lschen
        in      akku,TIMSK      ; altes Interrupt-Freigaberegister
        ori     akku,(1 << TOIE0) ; Zeitbasis Timer0 Interrupt frei
        out     TIMSK,akku      ; neues Interrupt-Freigaberegister
        sei                     ; Interrupts frei
; Arbeitsschleife 
loop:   nop                     ; tu nix
        rjmp    loop            ; 
; Timer0 Interrupt fr Zeitbasis 1 Sekunde
tic:    push    r16             ; Register retten
        in      r16,SREG        ; 
        push    r16             ;
        ldi     akku,-lade      ; Timer0 nachladen
        out     TCNT0,akku      ; 
        dec     zaehl           ; Durchlaufzhler - 1
        brne    tic1            ; noch keine Sekunde vergangen
        ldi     zaehl,durch     ; Durchlaufzhler Anfangswert
        push    r17             ;
        push    r18             ;
        in      r16,TCNT1L      ; R16 <- Low-Flankenzhler
        in      r17,TCNT1H      ; R17 <- High-Flankenzhler
        clr     r18             ; lschen
        out     TCNT1H,r18      ; Flankenzhler High
        out     TCNT1L,r18      ; Flankenzhler Low
        rcall   dual4bcd        ; R17:R16 dual -> R18:R17;R16 BCD
        out     PORTC,r17       ; Port C Tausender Hunderter
        out     PORTB,r16       ; Port B Zehner    Einer
        pop     r18             ; Register zurck
        pop     r17             : 
tic1:   pop     r16             ; Register zurck
        out     SREG,r16        ;
        pop     r16             ;
        reti                    ; 
; externes Unterprogramm 16bit dual -> 5 Stellen dezimal
       .INCLUDE "dual4bcd.asm"  ; R17:R16 dual -> R18:R17:R16 BCD
       .EXIT                    ; Ende des Quelltextes


