

; k4p17.asm  ATmega8  Test der SPI-Schnittstelle
; Systemtakt 1 MHz : 4 = 250 kHz Schiebetakt
; Port B: SPI Anschlsse nach 74HCT165 (Schalter) und 74HC595 (LED)
; Port D: Eingabe nach Empfnger-Slave
; Port C: Ausgabe des Sender-Slave 
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE "m8def.inc"    ; Deklarationen
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programmsegment
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupts bersprungen
start:  ldi     akku,LOW(RAMEND); Endadresse SRAM
        out     SPL,akku        ; nach Stapelzeiger
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Richtung Ausgabe
        out     DDRC,akku       ; Port C ist LED-Ausgabe
        ldi     akku,(1 << DDB5) | (1 << DDB3) | (1 << DDB2) | (1 << DDB1); 
        out     DDRB,akku       ; DDB5=SCK DDB3=MOSI DDB2=SRCK DDB1=SH/LD
        cbi     PORTB,PB1       ; Sender-Slave SH/LD = 0: laden
        sbi     PORTB,PB2       ; Empfnger-Slave bernahme RCK = 1
        ldi     akku,(1 << SPE) | (1 << MSTR) ; 
        out     SPCR,akku       ; SPI frei  MSB erst  Master  Takt/4
; Hauptprogramm Arbeitsschleife
haupt:  rcall   empf            ; akku <= Sender-Slave Schalter
        out     PORTC,akku      ; Kontrollausgabe Port C
        in      akku,PIND       ; Testwerte eingeben vom Port D
        com     akku            ; invertieren wegen Katodenansteuerung
        rcall   send            ; Ausgabe Empfnger-Slave LEDs
        rjmp    haupt           ; Schleife
; SPI-Unterprogramme        
; empf: Slave Schalter -> MISO -> Empfnger -> R16
empf:   sbi     PORTB,PB1       ; SH/LD = 1: schieben
        out     SPDR,r16        ; Start der bertragung
empf1:  sbis    SPSR,SPIF       ; berspringe wenn SPIF=1: bertragung fertig
        rjmp    empf1           ; warte auf Ende der bertragung
        in      r16,SPDR        ; Empfangsdaten abholen SPIF wird 0
        cbi     PORTB,PB1       ; SH/LD = 0: laden
        ret                     ; Rcksprung
; send: R16 -> Sender -> MOSI -> Slave Leuchtdioden
send:   cbi     PORTB,PB2       ; RCK bernahme Low
        out     SPDR,R16        ; Daten nach Sender Start der bertragung
send1:  sbis    SPSR,SPIF       ; berspringe wenn SPIF=1: bertragung fertig
        rjmp    send1           ; warte auf Ende der bertragung
        in      r16,SPDR        ; SPIF wieder 0
        sbi     PORTB,PB2       ; Slave steigende Flanke RCK: bernehmen
        ret                     ; Rcksprung
        .EXIT                   ; Ende des Programmtextes

