

; k4p16xp.asm  ATmega8  USART Test XON/XOFF-Protokoll
; Port B: Kontrollausgabe fr empfangene Zeichen
; Port C: -
; Port D: PD0 -> RXD  PD1 -> TXD  PD2 = XON  PD3 = XOFF 
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .EQU    baud = 9600     ; Baudrate
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    INT0addr        ; Einsprung INT0 PD2
        rjmp    ein             ;
        .ORG    INT1addr        ; Einsprung INT1 PD3
        rjmp    aus             ; 
        .ORG    $13             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ;
        out     DDRB,akku       ; Port B ist Ausgang fr Zeichencode
        rcall   initusart2      ; USART initialisieren doppelte Baudrate
        in      akku,MCUCR      ; Haupt-Steuerregister
        ori     akku,0b00001010 ; INT1 und INT0 fallende Flanke
        out     MCUCR,akku      ;
        in      akku,GICR       ; Interrupt-Freigaberegister
        ori     akku,0b11000000 ; INT1 und INT0 frei
        out     GICR,akku       ;
        sei                     ; alle Interrupts frei
neu:    ldi     akku,'>'        ; Prompt >
        rcall   putch           ; ausgeben
loop:   rcall   getche          ; Zeichen mit Echo empfangen
        out     PORTB,akku      ; Kontrollausgabe auf Port B
        rjmp    loop            ; und neue Eingabe
; Konsolunterprogramme einfgen
       .INCLUDE "konsole.h"     ; initusart2,putch,getch,getche,kbhit
; Interrupteinsprnge fr XON und XOFF senden
ein:    push    akku             ; Taste PD2 INT0
        ldi     akku,$11         ; XON
        rcall   putch            ; senden
        pop     akku             ;
        reti                     ; 
aus:    push    akku             ; Taste PD3 INT1
        ldi     akku,$13         ; XOFF
        rcall   putch            ; senden
        pop     akku             ;
        reti                     ; 
        .EXIT                    ; Ende des Quelltextes

