

; k4p11.asm  ATmega8  Timer2 Sekundenzhler
; Port D: Ausgabe dezimal 00 bis 59 Sekunden
; Port B: Quarz 32 768 Hz an TOSC1 (PB6) und TOSC2 (PB7)
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    seku = r18      ; Sekundenzhler
        .CSEG                   ; Programmbereich
        rjmp    start           ; Einsprung nach Reset
        .ORG    OVF2addr        ; Einsprung berlauf Timer2
        rjmp    tictac          ; jede Sekunde Uhr weiterstellen
        .ORG    $13             ; alle anderen Interrupts nicht besetzt
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku         ; 
        ser     akku            ; akku <= $FF
        out     DDRD,akku       ; Port D Ausgang
        clr     seku            ; Sekunde lschen 
        out     PORTB,seku      ;  
        in      akku,TIMSK      ; akku <= Timer Interrupt Masken
        ori     akku,(1 << TOIE2); 
        out     TIMSK,akku      ; Timer2 berlauf Interrupt frei
        in      akku,ASSR       ; akku <- asynchrone Kontrolle
        ori     akku,1 << AS2   ; asynchrone Betriebsart ext. Quarz
        out     ASSR,akku       ; einstellen
        ldi     akku,(1 << CS22) | (1 << CS20) ; Teiler:128 gibt 256
        out     TCCR2,akku      ; als Vorteiler
        sei                     ; I = 1: alle Interrupts frei
warte:  rjmp    warte           ;
; Einsprung Interrupt Timer2 jede Sekunde berlauf BCD-Umwandlung
tictac: push    akku            ; Register retten
        in      akku,SREG       ; 
        push    akku            ;
        push    r17             ; dual2bcd zerstrt R17!
        inc     seku            ; Sekunde erhhen
        cpi     seku,60         ; mod 60 
        brlo    tictac1         ; < 60: weiter
        clr     seku            ; >= 60: null
tictac1:mov     akku,seku       ;
        rcall   dual2bcd        ; Umwandlung dual -> BCD
        out     PORTD,akku      ; BCD ausgeben
        pop     r17             ; Register zurck
        pop     akku            ; 
        out     SREG,akku       ;
        pop     akku            ;
        reti                    ; zurck aus Interrupt
; externes Unterprogramm
        .INCLUDE "dual2bcd.asm" ; R16 dual nach R17 und R16 BCD
        .EXIT                   ; Ende des Quelltextes
