

; k2p3.asm ATmega8 Dualzhler mit Verzgerungsschleife Systemtakt 1 MHz
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111        
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testschleife in einfhrendes Beispiel einbauen *****************
; 1 ms Low / 1 ms High Teiler an PB0 / 2000 gemessen 492 Hz PB7 blinkt *
loop:   in      akku,PORTB      ; Eingabe alter Zhler                 *
        inc     akku            ; Zhler um 1 erhhen                  *
        out     PORTB,akku      ; neuen Zhler ausgeben                *
        ldi     r17,250         ; Wartezeit 250x4 ca. 1 ms             *
warte:  nop                     ; 1 Takt: Zeitverzgerung              *
        dec     r17             ; 1 Takt  Wartezhler - 1              *
        brne    warte           ; 2 Takte Sprung bis Wartezhler Null  *
        rjmp    loop            ; Sprung zum Anfang der Ausgabeschleife*
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


