

; k2p23.asm ATmega8 gepufferte 16bit Eingabe und direkte 16bit Ausgabe
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: PC-Terminal: PD0:RXD PD1:TXD PD2-PD7 frei 
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern
        .EQU    BAUD = 9600     ; Baudrate fr USART
        .EQU    NPUF = 80       ; Lnge Eingabepuffer im SRAM
        .DEF    akkul = r16     ; Arbeitsregister Low
        .DEF    akkuh = r17     ; Arbeitsregister High
        .DEF    retter = r18    ; Retter fr Ausgabe hexa und binr
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akkul,LOW(RAMEND); Stapel anlegen
        out     SPL,akkul       ; 
        ldi     akkul,HIGH(RAMEND) ; 
        out     SPH,akkul       ; 
        ldi     akkul,$ff       ; Bitmuster 1111 1111
        out     DDRB,akkul      ; Richtung Port B ist Ausgang
        out     DDRC,akkul      ; Richtung Port C ist Ausgang
        rcall   initusart2      ; USART doppelte Baudrate mit BAUD und takt
        ldi     ZL,LOW(prompt*2) ; Z <- Adresse Ausgabetext
        ldi     ZH,HIGH(prompt*2);
; Arbeitsschleife 
loop:   rcall   puts            ; Prompt: Eingabe -> 
        ldi     YL,LOW(puffer)  ; Y <- Adresse Eingabepuffer
        ldi     YH,HIGH(puffer) ;
        rcall   gets            ; Eingabezeile nach Puffer Ende mit cr
        rcall   ein16           ; R17:R16 <- Eingabewert
        brcs    error           ; C = 1: Eingabefehler
        rcall   ausdez16        ; R17:R16 dezimale Kontrollausgabe
        mov     retter,akkul    ; 
        mov     akkul,akkuh     ; 
        rcall   aushex8         ; R17:R16 hexadezimale Kontrollausgabe
        mov     akkul,retter    ; 
        rcall   aushex8a        ; 
        mov     akkul,akkuh     ;
        rcall   ausbin8         ; R17:R16 binre Kontrollausgabe
        mov     akkul,retter    ;
        rcall   ausbin8a        ; 
        rjmp    loop            ; 
; Fehlermeldung
error:  ldi     akkul,'?'       ; Fragezeichen
        rcall   ausz            ;
        ldi     akkul,7         ; Code fr Bell = Hupe
        rcall   ausz            ;
        rjmp    loop            ;
; interne Unterprogramme fr Gert und Betriebsart
ausz:   rcall   putch           ; direkte Ausgabe nach USART
        ret                     ; 
einz:   ld      r16,Y+          ; gepufferte Eingabe von USART aus (Y)
        ret                     ; 
; externe Unterprogramme fr USART und Umwandlung
        .INCLUDE "usart.h"      ; USART-Programme fr Zeichen und Strings
        .INCLUDE "einaus.h"     ; Umwandlungsprogramme zur Ein/Ausgabe 
;
; Ausgabetext
prompt: .DB     10,13,"Eingabe -> ",0
;
; SRAM-Bereich 
        .DSEG                   ; Datenbereich
puffer: .BYTE   NPUF            ; Eingabepuffer fr gets
        .EXIT                   ; Ende des Quelltextes

