

; k2p14.asm ATmega8 Aufbau und Ausgabe einer Liste im SRAM
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
; Aufbau der Liste mit Werten von 0 bis 255 im SRAM                    *
        ldi     XL,LOW(stab)    ; X <- Listenadresse fr Speicherung   *
        ldi     XH,HIGH(stab)   ;                                      *
        clr     akku            ; Zhler und Anfangswert Null          *
aufbau: st      X+,akku         ; Wert nach Liste, Zeiger erhhen      *
        inc     akku            ; Wert und Zhler erhhen              *
        brne    aufbau          ; bis berlauf bei 255 + 1 = 256 Werte *
; Ausgabe der Liste in einer Schleife bei fallender Flanke an PD7      *
        ldi     XL,LOW(stab)    ; X <- Listenadresse fr Ausgabe       *
        ldi     XH,HIGH(stab)   ;                                      *
        ldi     akku,$55        ; Test-Anfangswert                     *
        out     PORTB,akku      ; auf Port B ausgeben                  *
loop:   sbic    PIND,PIND7      ; berspringe wenn Taste PD7 gedrckt  *
        rjmp    loop            ; warte solange Taste nicht gedrckt   *
        ld      akku,X          ; fallende Flanke: Wert aus Liste      *
        out     PORTB,akku      ; ausgeben                             *
        inc     XL              ; nur Low-Teil erhhen                 *
warte:  sbis    PIND,PIND7      ; berspringe wenn Taste PD7 gelst    *
        rjmp    warte           ; warte solange Taste gedrckt         *
        rjmp    loop            ; zyklische Ausgabe                    *
; Datenbereich im SRAM                                                 *
        .DSEG                   ; Datensegment                         *
        .ORG    $100            ; Anfangsadresse nur Low-Teil erhht!  *
stab :  .BYTE   256             ; 256 Bytes fr Liste                  *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


