

; k2p12.asm ATmega8 Tabellendirektzugriff binr nach Hexa-ASCII-Zeichen
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
loop:   in      akku,PIND       ; Eingabe Binrcode 0 bis 15           *
        andi    akku,$0F        ; Maske 0000 1111                      *
        ldi     ZL,LOW(atab*2)  ; Z <- Tabellenanfangsadresse          *
        ldi     ZH,HIGH(atab*2) ;                                      *
        add     ZL,akku         ; addiere Eingabewert                  *
        clr     akku            ; akku lschen, Carry unverndert!     *
        adc     ZH,akku         ; addiere Null + bertrag              *
        lpm                     ; R0 <- Tabellenwert Hexa-ASCII-Zeichen*
        out     PORTB,r0        ; ausgeben                             *
        rjmp    loop            ; neue Eingabe                         *
; Tabelle  enthlt nur Ausgabezeichen ohne Endemarke                   *
atab:  .DB      "0123456789ABCDEF"   ; ASCII-String                    *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


