

// lcd4func.c Funktionstasten fr Cursorkontrolle
void lcd4func (unsigned char code)
{
 switch(code)
 {
  case 1: lcd4put(' '); lcd4cur(); break;  // Leerzeichen ausgeben
  case 2: break;                            // nicht belegt
  case 3: break;                            // nicht belegt
  case 4: if (curpos >= 0x50) break;       // Cursor abwrts ausser 4.Zeile
           if (curpos < 0x10) { curpos += 0x40; lcd4com(curpos | 0x80); break;}  // 1 -> 2
           if (curpos < 0x20) { curpos += 0x40; lcd4com(curpos | 0x80); break;}  // 3 -> 4
           if (curpos < 0x50) { curpos -= 0x30; lcd4com(curpos | 0x80); break;}  // 2 -> 3
  case 5: if (curpos < 0x10) break;         // Cursor aufwrts ausser 1.Zeile
           if (curpos >= 0x50) { curpos -= 0x40; lcd4com(curpos | 0x80); break;} // 4 -> 3
           if (curpos >= 0x40) { curpos -= 0x40; lcd4com(curpos | 0x80); break;} // 2 -> 1
           if (curpos >= 0x10) { curpos += 0x30; lcd4com(curpos | 0x80); break;} // 3 -> 2
  case 6: if ((curpos & 0x0f) == 0) break; else {curpos--; lcd4com(0x10); break;}    // <-
  case 7: if ((curpos & 0x0f) == 0x0f) break; else {curpos++; lcd4com(0x14); break;} // ->
  case 8: lcd4com(0x01); lcd4com(0x02); curpos = 0; break;    // Cursor home und lschen
  case 9: curpos &= 0xf0; lcd4com(curpos | 0x80);              // return Zeile lschen und Anfang
           for (unsigned char i = 1; i <= 16; i++) lcd4put(' '); lcd4com(curpos | 0x80); break;
 } // Ende switch
} // Ende lcd4func

