

// k7p4.c Wrfel mit 90S2343 Takt 1 MHz Sonderfunktion 1..7
// Port B: PB0..PB3: LED-Ausgabe Katoden  PB4: Tasteneingabe
#include  <io.h>                         // Deklarationen
#define  TAKT 1000000ul                  // Systemtakt 1 MHz fr wartex10ms
#include  "c:\cprog3\wartex10ms.c"       // Wartefunktion einfgen
void main (void)                        // Hauptfunktion
{
 unsigned char i, zaehler = 6;
 unsigned char tab[7] = {0x01,0x02,0x03,0x06,0x07,0x0e,0x0f}; // Ausgabemuster 
 DDRB = 0x0f;                             // B7..B5 = x  B4 = ein  B3..B0 = aus
 if (!(PINB & (1 << PB4))) zaehler = 7;  // Taste PB4 beim Start gedrckt
 for (i=0; i < zaehler; i++)            // Schleife fr Lampentest
 {
  PORTB = ~tab[i];                       // komplementierten Wert ausgeben
  wartex10ms(50);                        // 50*10ms = 500 ms warten
 } // Ende for 
 PORTB = 0xff;                            // alle LEDs wieder aus
 while (1)                               // Wrfelschleife ohne Zeitausgleich 
 {
  for (i=0; i<zaehler; i++)             // alle Werte 1 .. durchgehen
  {
   if (!(PINB & (1 << PB4)))           // Taste Low = gedrckt
   {
    PORTB = ~tab[i];                    // gewrfelte Augen ausgeben
    wartex10ms(5);                      // 50 ms warten entprellen
    while ( !(PINB & (1 << PB4)));    // warte auf steigende Flanke
    wartex10ms(5);                      // 50 ms warten entprellen
    PORTB = 0xff;                       // Anzeige wieder aus
   } // Ende if
  } // Ende for
 } // Ende while  
} // Ende main
