

// k5p1.c ATmega8 Boot-Lader One-Task-Version
// Port B: -
// Port c: -
// Port D: 
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include  <io.h>                         // Deklarationen
#include <avr/boot.h>                    // 
#include <avr/pgmspace.h>
#define  TAKT 1000000ul                  // Systemtakt 1 MHz 
#define  BAUD 9600ul                     // Baudrate
#define BOOT  __attribute__ ((section (".bootloader")))
// #define BOOT 
void initusart2(void) BOOT ;
void putch(unsigned char x) BOOT ;
void putstring(unsigned char *zeiger) BOOT ;
unsigned char getch(void)  BOOT ;
unsigned char getche(void) BOOT ;
void main(void) BOOT ;                
// initusart2 USART initialisieren doppelte Baudrate
void initusart2(void)                // USART initialisieren
{
 unsigned char x;                      // Hilfsvariable
 UBRRL = (TAKT / (8ul * BAUD)) - 1;    // Baudrate mit TAKT und BAUD
 UBRRH = 0;                            // 
 UCSRA |= (1 << U2X);                  // U2X doppelte Baudrate fr Faktor 8
 UCSRB |= (1 << TXEN) | (1 << RXEN);   // Sender und Empfnger ein
 UCSRC |= (1 << URSEL) | (1 << UCSZ1) | (1 << UCSZ0); // async 8bit
 x = UDR;                              // Empfnger leeren
}
// putch Zeichenausgabe fr USART und UART
void putch (unsigned char x)      // warten und Zeichen senden
{
 while( ! (UCSRA & (1 << UDRE)));  // warte solange Sender besetzt
 UDR = x;                          // Zeichen nach Sender 
}
// putstring  String bis Endemarke Null ausgeben
void putstring(unsigned char *zeiger)  // SRAM_String ausgeben
{
 while(*zeiger != 0) putch(*zeiger++); // solange keine Endemarke NULL
}
// getch Zeichen von USART oder UART holen
unsigned char getch(void)         // warten und Zeichen abholen
{ 
 while ( ! (UCSRA & (1 << RXC))); // warte bis Zeichen da
 return UDR;                      // Zeichen abholen
}
// getche Eingabe mit Echo von USART oder UART
unsigned char getche(void)        // warten und lesen mit Echo
{
 int x;                           // Hilfsvariable
 while ( ! (UCSRA & (1 << RXC))); // warte bis Zeichen da
 x = UDR;                         // abholen und speichern
 while( ! (UCSRA & (1 << UDRE))); // warte solange Sender besetzt
 UDR = x;                         // Echo senden 
 return x;                        // Zeichen zurckgeben
}

void main (void)                        // Hauptfunktion
{
// Ausgabetexte
 unsigned char meldung[] = "\n\rBoot-Monitor 1.0\n\r";
 unsigned char x;
 initusart2();                   // USART initialisieren
 putstring(meldung);
 while(1)
 {
 x = getch();
 putch(x);
 }       
} // Ende main
