

// k4p6.c ATmega8  Timer1: Flankenzhler  Timer0: Zeitbasis
// Port B: Ausgabe                       Zehner  Einer
// Port C: Ausgabe  Tausender Hunderter
// Port D: Eingang  T1 = PD5 Messfrequenz
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>              // Deklarationen
#include <avr/signal.h>          // fr Interrupt
#include <avr/interrupt.h>       // fr Interrupt
#define TAKT 1000000UL           // Systemtakt intern ca. 1 MHz
#define durch 125                // Durchlaufzhler 
#define nach 125                 // Nachladewert
volatile unsigned char zaehl = durch; // Durchlaufzhler
unsigned char ein, zehn, hund, taus, ztaus;  //  BCD-Stellen 
unsigned int dual;               // 16bit Flankenzhler Timer1
#include "dual5bcd.c"            // 16bit dual nach BCD fnfstellig
SIGNAL(SIG_OVERFLOW0)            // Serviceroutine bei Timer0 berlauf
{                                // Einsprung 61 mal pro Sekunde
 TCNT0 = -nach;                  // Timer0 nachladen
 zaehl--;                        // Durchlaufzhler - 1
 if (zaehl == 0)                 // wenn Sekunde vergangen
 {
  zaehl = durch;                 // neuer Anfangswert
  dual = TCNT1;                  // Timer1 Flankenzhler nach einer Sekunde
  TCNT1 = 0;                     // Timer1 Flankenzhler lschen
  dual5bcd(dual, &ein, &zehn, &hund, &taus, &ztaus); // dual -> BCD
  PORTB = (zehn << 4) | ein;     // Port B Zehner    und Einer
  PORTC = (taus << 4) | hund;    // Port C Tausender und Hunderter
 } 
} 
void main(void)                  // Hauptfunktion
{            
 DDRB = 0xff;                    // Port B ist Ausgang
 DDRC = 0xff;                    // Port C ist Ausgang
 OSCCAL = 0xC2;                  // RC Oszillator kalibrieren
 TCNT1 = 0;                      // Timer1 Anfangswert
 TCCR1B = 0x06;                  // Timer1 110  externer Takt T1 PD5
 zaehl = durch;                  // Timer0 Durchlaufzhler
 TCNT0 = -nach;                  // Timer0 Nachladewert 
 TCCR0 = 0x03;                   // Timer0 011 Systemtakt :256 : 64 = 61.03 Hz 
 TIMSK |= (1 << TOIE0);          // Timer0 berlauf Interrupt frei
 sei();                          // I = 1: alle Interrupts frei
 while(1) {}                     // Schleife tut nix mehr 
} // Ende main
