

// k4p25.c ATmega16 serielle analoge Wandler
// PORT C: Ausgabe Hunderter
// Port B: Ausgabe Zehner und Einer
//; Port D: PD0:CLK A/D: PD4=DOUT PD3=/CS  D/A:PD2=DIN PD1=/LOAD 
#include <avr/io.h>         // Deklarationen
#define TAKT 3686400UL      // Controllertakt 3.6864 MHz
#define ZEIT 50UL           // Wartezeit 50us fr 10 kHz Takt
#define FAKTOR (ZEIT * TAKT) / (1000000UL * 3UL) // Wartefaktor
// Funktion Wartezeit fr Halbperiode 50 us des Taktes 10 kHz
void warte(unsigned char x)
{
 unsigned char i;       // Wartezhler
 for(i=0; i<x; i++);    // bis 0 herabzhlen
}
// Funktion serielle Eingabe vom A/D-Wandler LTC 1286 
unsigned int serein(void)
{
 unsigned int wert = 0;  // Ergebnis lschen
 unsigned char i;        // Bitzhler
 cbi(PORTD,PD3);          // /CS Low: Wandler freigegeben
 for(i=1; i<=15; i++)    // Abtastungen
 {
  // fallende Flanke ausgeben
  cbi(PORTD,PD0);         // Takt -> Low
  warte(FAKTOR);          //  Halbperiode warten
  // steigende Flanke ausgeben
  sbi(PORTD,PD0);        // Takt -> High
  // bei steigender Flanke abtasten
  wert = wert << 1;      // 1 bit links
  if (bit_is_set(PIND,PIND4)) wert++; // fr High setze Bit
  warte(FAKTOR);         // Halbperiode warten  
 } // Ende for
 warte(FAKTOR);          // vor Sperrung Halbperiode warten
 sbi(PORTD,PD3);         // /CS High: Wandler gesperrt
 wert = wert & 0x0fff;   // 4 bit maskieren
 return wert;             // Rckgabe rechtsbndig  
} // Ende serein
  
// Funktion serielle Ausgabe nach D/A-Wandler LTC 1257
void seraus(unsigned int x)
{
 unsigned char i;        // Zhler
 for(i=1; i<=12; i++)    // Ausgabeschleife
 {
 // fallende Flanke und Daten ausgeben
  cbi(PORTD,PD0);        // Takt -> Low 
  if(x & 0x0800) sbi(PORTD,PD2); else cbi(PORTD,PD2);
  x = x << 1;            // 1 bit links
  warte(FAKTOR); 
 // steigende Flanke ausgeben
  sbi(PORTD,PD0);       // Takt -> High
  warte(FAKTOR);         // Halbperiode warten
 } // Ende for
 // Ladeimpuls ausgeben
  cbi(PORTD,PD1);       // /LOAD Low 
  x = x << 1;           // kurz warten                
  sbi(PORTD,PD1);       // /LOAD High
} // Ende seraus

main(void)           // Hauptfunktion
{
 unsigned int wert; // Hilfsvariable fr Digitalwert
 DDRB = 0xff;        // Port B Ausgabe 
 DDRC = 0xff;        // Port C Ausgabe
 DDRD = 0x0f;        // D3-D0 Ausgabe Wandlersteuerung
 PORTD = 0x0f;       // alle Ausgnge High 
 while(1)           // Arbeitsschleife
 {
  wert = serein();   // Eingabe vom seriellen A/D-Wandler 12 rechtsbndig
  seraus(wert);      // Wert wieder seriell auf D/A-Wandler ausgeben
  wert = wert >> 4;  // nur High-Byte auf BCD-Anzeige 3 stellig
  PORTC = wert/100;  // Hunderter BCD ausgeben
  PORTB = ((wert%100)/10 << 4) | ((wert%100)%10); // Zehner und Einer 
 } // Ende while
} // Ende main

