

// k4p22.c ATmega8 A/D-Wandler Betriebsart Einzelwandlung
// Port B: Ausgabe dual Low-Byte
// Port D: Ausgabe dual D3 - D0 High-Bits
// Port C: Eingabe PC0 10 kOhm Potentiometer
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include  <avr/io.h>       // Deklarationen
void main (void)
{
 DDRB = 0xff;             // 1111 1111 Port B ist Ausgang
 DDRD = 0x0f;             // 0000 1111 Port D3-D0 Ausgnge
 ADMUX = 0x00;            // Ref Pin Aref, rechtsbndig, Kanal PC0
 ADCSR = (1 << ADEN) | (1 << ADSC) | (1 << ADPS1) | (1 << ADPS0); 
 while (1)                // Wandlungstakt 1 MHZ : 8 = 125 kHz
 {
  while(ADCSRA & (1 << ADSC)); // Warte auf Ende der Wandlung
  PORTB = ADCL;            // Low-Byte nach Port B
  PORTD = ADCH;           //  High-Byte nach Port D
  sbi(ADCSRA,ADSC);       // Wandler neu starten
 } // Ende While
} // Ende main