

// k4p19.c  ATmega8  TWI-Schnittstelle PCF8574A 
// Port B: Ausgabe der Empfangsdaten
// Port C: PC1 = SDA -> Stift 15  PC0=SCL -> Stift 14 PCF8574A 
// PORT D: Eingabe der Sendedaten
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include <avr/io.h>         // Deklarationen
#define TAKT 1000000UL      // Systemtakt 1 MHz
#define AUSAD 0x70          // Adresse Ausgabeeinheit PCF8574A
#define EINAD 0x71          // Adresse Eingabeeinheit PCF8574A
#define FAKTOR 10           // Teilerfaktor fr 10 kHz Bustakt
#define TEILER 1            // Vorteiler TWPS = 1
 void init(unsigned char faktor, unsigned char teiler)  // TWI initialisieren
 {
  TWBR = faktor;            // Bitrate
  TWSR = teiler;            // Vorteiler
 }
 void send(unsigned char adres, unsigned char daten) // Zeichen senden
 {
  TWCR = (1 << TWINT) | (1 << TWSTA) | (1 << TWEN);   // Startbedingung
  loop_until_bit_is_set(TWCR, TWINT);                  // warte bis fertig
  TWDR = adres;                                        // Adresse
  TWCR = (1 << TWINT) | (1 << TWEN);                  // senden
  loop_until_bit_is_set(TWCR, TWINT);                  // warte bis fertig
  TWDR = daten;                                        // Daten
  TWCR = (1 << TWINT) | (1 << TWEN);                  // senden
  loop_until_bit_is_set(TWCR, TWINT);                  // warte bis fertig
  TWCR = (1 << TWINT) | (1 << TWSTO) | (1 << TWEN);  // Stoppbedingung
 }
 unsigned char empf(unsigned char adres)            // Zeichen empfangen
 {
  unsigned char daten;                               // Hilfsvariable
  TWCR =  (1 << TWINT) | (1 << TWSTA) | (1 << TWEN); // Startbedingung
  loop_until_bit_is_set(TWCR, TWINT);                  // warte bis fertig
  TWDR = adres;                                        // Adresse
  TWCR = (1 << TWINT) | (1 << TWEN);                  // senden
  loop_until_bit_is_set(TWCR, TWINT);                  // warte bis fertig
  TWCR = (1 << TWINT) | (1 << TWEN);                  // Empfang starten
  loop_until_bit_is_set(TWCR, TWINT);                  // warte bis fertig
  daten = TWDR;                                        // Daten abholen
  TWCR = (1 << TWINT) | (1 << TWEA) | (1 << TWEN);   // ACK-Impuls senden
  loop_until_bit_is_set(TWCR, TWINT);                  // warte bis fertig
  TWCR = (1 << TWINT) | (1 << TWSTO) | (1 << TWEN);  // Stoppbedingung
  return daten; 
 }
 void main (void)             // Hauptfunktion
 {
  unsigned char awert, ewert; // Zwischenwerte fr Test
  DDRB = 0xff;                 // Port B gibt Testdaten aus
  init(FAKTOR, TEILER);        // TWI Bustakt Initialisierung 
  while (1)                   // Arbeitsschleife
  {
   awert = PIND;              // Testwerte vom Port D eingeben
   send(AUSAD, ~awert);       // Komplement senden
   ewert = empf(EINAD);       // Empfangsdaten
   PORTB = ewert;             // auf Port B ausgeben 
  } // Ende  while
 } // Ende main