

// k4p18.c  ATmega8 Software-Emulation der SPI-Schnittstelle 
// Port B: Software-SPI 74HCT165 und 74HC595
// Port C: Eingabe fr Empfnger-Slave
// Port D: Ausgabe des Sender-Slave 
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include <avr/io.h>                 // Deklarationen
unsigned char empf(void)         // liefert Schalter des Sender-Slave MSB zuerst
{
 unsigned char daten, i;          // Hilfsvariable und Zhler fr 8 Bits
 sbi(PORTB,PB1);                   // SH/LD = 1: schieben QH liegt an
 for(i=1; i<=8; i++)              // fr 8 Bits
 {
  cbi(PORTB, PB5);                 // Takt Low 
  daten = daten << 1;              // logisch links B0 <= 0 
  if (bit_is_set(PINB, PINB4)) daten++; //  fr MI = 1: B0 <= 1
  sbi(PORTB, PB5);                 // steigende Taktflanke: Slave schiebt  
 } // Ende for
 cbi(PORTB,PB1);                  // SH/LD = 0: laden
 return daten;                    // Empfangsdaten zurckliefern 
} // Ende empf

void send(unsigned char wert)   // sendet seriell nach Empfnger-Slave MSB zuerst
{
 unsigned char i;                // Zhler fr 8 Bits 
 cbi(PORTB,PB2);                  // RCK bernahme Low
 for(i=1; i<=8; i++)             // fr 8 Bits
 {
  cbi(PORTB, PB5);                // Takt Low
  cbi(PORTB, PB3);                // Ausgabebit Low
  if( (wert & 0x80) == 0x80) sbi(PORTB, PB3); // fr B7 = 1 Ausgabebit High
  wert = wert << 1;               // das nchste Bit fertig machen
  sbi(PORTB, PB5);                // Slave steigende Schiebeflanke
 } // Ende for
 sbi(PORTB,PB2);                 // RCK bernahme High: steigende Flanke
} // Ende send

void main(void)         // Hauptfunktion
{
 DDRC = 0xff;            // Port C ist Ausgang
 DDRB = (1 << DDB5) | (1 << DDB3) | (1 << DDB2) | (1 << DDB1); // SPI Ausgnge 
 cbi(PORTB,PB1);        // Sender-Slave SH/LD = 0: laden
 sbi(PORTB,PB2);        // Empfnger-Slave bernahme RCK=1
 while(1)              // Arbeitsschleife
 {
  PORTC = empf();      // Kontrollausgabe Port C
  send(~PIND);        // senden invertiert LEDs Katodenansteuerung
 } // Ende while
} // Ende main