

// k3p4.c  ATmega8 verzgerter Dezimalzhler 
// Port B: Ausgabe           Zehner | Einer
// Port C: Ausgabe Hunderter
// Port D: Eingabe Wartefaktor * 10ms
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>                 // Deklarationen
#define TAKT 1000000UL              // Symbol Controllertakt 1 MHz
#include "wartex10ms.c"             // wartet Faktor * 10 ms
#include "dual2bcd.c"               // Umwandlung dual nach dezimal
void main(void)                     // Hauptfunktion
{
 unsigned char zaehler = 0;         // Bytevariable
 DDRB = 0xff;                       // Port B ist Ausgang
 DDRC = 0xff;                       // Port C ist Ausgang
 while(1)                           // Arbeitsschleife
 {
  PORTC = dual2bcd(zaehler) >> 8;   // Zhler Hunderter 
  PORTB = dual2bcd(zaehler);        // Zhler Zehner | Einer
  zaehler++;                         // Zhler dual erhhen
  wartex10ms(PIND);                 // Faktor dual vom Port D
 } // Ende while 
} // Ende main
