

; test6.asm Test Multiplikationen
; Port B: Ausgabe 
; Port D: Eingabe 
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    takt = 8000000  ; Takt 8 MHz
        .DEF    akku = r16      ; Arbeitsregister
; Makrodefinitionen
        .INCLUDE "Mmul16.asm"   ; Hardware-Multiplikation 16 * 16 -> 32 bit
        .INCLUDE "Mmulx8.asm"   ; Software-Multiplikation  8 * 8  -> 16 bit
        .INCLUDe "Mmulx16.asm"  ; Software-Multiplikation 16 * 16 -> 32 bit
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Endadresse_Low SRAM
        out     SPL,akku        ; nach Stapelzeiger_Low
        ldi     akku,HIGH(RAMEND) ; Endadresse_High SRAM
        out     SPH,akku        ; nach Stapelzeiger_High
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        out     DDRC,akku       ; 
; Test der 8bit Multiplikation
haupt8: clr     r16             ;
        clr     r17             ;
haupt8a:mul     r16,r17         ; R1:R0 <- R16 * R17
        movw    r3:r2,r1:r0     ; Produkt retten
        rcall   mulx8           ; R1:R0 <- R16 * R17
        cp      r2,r0           ; Low-Produkt 
        cpc     r3,r1           ; High-Produkt
        brne    error           ;
        out     PORTB,r16       ;
        out     PORTC,r17       ;
        inc     r16             ;
        brne    haupt8a         ;
        inc     r17             ;
        brne    haupt8a         ;
; Test der 16bit Multiplikation
haupt9: clr     XL              ;
        clr     XH              ;
        clr     YL              ;
        clr     YH              ;
haupt9a:movw    r17:r16,XH:XL   ;
        movw    r19:r18,YH:YL   ;
        rcall   mul16           ; R3:R2:R1:R0 <- R17:R16 * R19:R18
        movw    r5:r4,r1:r0     ; Produkt_Low retten
        movw    r7:r6,r3:r2     ; Produkt_High retten
        rcall   mulx16          ; R3:R2:R1:R0 <- R17:R16 * R19:R18
        cp      r4,r0           ; Low-Produkt 
        cpc     r5,r1           ; 
        cpc     r6,r2           ;
        cpc     r7,r3           ; High-Produkt
        brne    error           ;
        out     PORTB,r19       ; Faktor_1 High
        out     PORTC,r17       ; Faktor_2 High
        adiw    XL,1            ; Faktoren erhhen
        brne    haupt9a         ;
        adiw    YL,1            ;
        brne    haupt9a         ;
; neuer 8bit Test
        rjmp    haupt8          ;
; Fehlermeldung
error:  rjmp    PC
; Unterprogramme
        .INCLUDE "mul16.asm"    ; R3:R2:R1:R0 <- R19:R18 * R17:R16 mul-Befehle
        .INCLUDE "mulx8.asm"    ; R1:R0 <- R16 * R17               Software
        .INCLUDE "mulx16.asm"   ; R3:R2:R1:R0 <- R19:R18 * R17:R16 Software
        .EXIT                   ; Ende des Quelltextes


