

; k7p7.asm ATmega88 ersetzt zwei 74LS47 mit Hexaziffern
; Port B: PB0 - PB6 7Segmentausgnge rechts PB7 g-links
; Port C: PC0 - PC5 7Segmentausgnge links  PC6 Reset frei
; Port D: BCD Eingnge D7-D4 rechts D3-D0 links
; Fuses: Int. RC Osc. 1 MHz PB6 und PB7 als Port 
        .INCLUDE    "m88def.inc"    ; Deklarationen fr Mega8
        .CSEG                       ; Programm-Flash
        rjmp        start           ; Reset-Einsprung
        .ORG        $13             ; Interrupteinsprnge bergehen
start:  ldi         r16,LOW(RAMEND) ; Stapel anlegen
        out         SPL,r16         ;
        ldi         r16,HIGH(RAMEND); 
        out         SPH,r16         ;
        ldi         r16,$FF         ; 1111 1111 
        out         DDRB,r16        ; PB7 - PB0 sind Ausgnge
        ldi         r16,$7F         ; 0111 1111
        out         DDRC,r16        ; PC6 - PC0 sind Ausgnge
loop:   in          r16,PIND        ; R16 <- zwei BCD-Eingnge
        mov         r17,r16         ; R17 <- retten
        ldi         ZL,LOW(tab*2)   ; Z <- Tabellenadresse
        ldi         ZH,HIGH(tab*2)  ;
        andi        r16,$0F         ; Maske 0000 1111 D3-D0 links 
        add         ZL,r16          ; Z <- Z + Abstand
        clr         r16             ;
        adc         ZH,r16          ;
        lpm                         ; R0 <- (Z) Tabellenzugriff
        mov         r16,r0          ; R16 <- Code links
        ldi         ZL,LOW(tab*2)   ; Z <- Tabellenadresse
        ldi         ZH,HIGH(tab*2)  ;
        swap        r17             ; R17 Hlften vertauschen
        andi        r17,$0F         ; Maske 0000 D7-D4 1111 rechtsi
        add         ZL,r17          ; Z <- Z + Abstand
        clr         r17             ;
        adc         ZH,r17          ;
        lpm                         ; R0 <- (Z) Tabellenzugriff
        mov         r17,r0          ; R17 <- Code rechts
        mov         r18,r16         ; R18 <- Code links
        lsl         r18             ; Bit_7 <- Bit_6  g-Segment
        andi        r18,$80         ; Maske 1000 0000 fr Bit_7
        or          r17,r18         ; g-Segment links einbauen
        out         PORTB,r17       ; nach Anzeige rechts mit g-links
        out         PORTC,r16       ; nach Anzeige links
        rjmp        loop            ;
; Codetabelle fr Ziffern 0 - 9 und A b C d E F fr gemeinsame Anode !!!
tab:    .DB         $40,$79,$24,$30,$19,$12,$02,$78,$00,$18,$08,$03,$46,$21,$06,$0E
        .EXIT                       ; Ende des Programmsegments
