

; k7p11.asm ATmega16 Test Pseudo-Zufallszahlen
; Port A: Ausgabe High-Byte
; Port B: Ausgabe Middle-High-Byte
; Port C: Ausgabe Middle-Low-Byte
; Port D: Ausgabe Low-Byte
; Konfiguration Quarz 3.6864 MHz  JTAG Interface disabled!
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    takt = 3686400  ; Takt 3.6864 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; 
start:  ldi     akku,LOW(RAMEND); Endadresse_Low SRAM
        out     SPL,akku        ; nach Stapelzeiger_Low
        ldi     akku,HIGH(RAMEND) ; Endadresse_High SRAM
        out     SPH,akku        ; nach Stapelzeiger_High
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRA,akku       ; A7-A0 Ausgang
        out     DDRB,akku       ; B7-B0 Ausgang
        out     DDRC,akku       ; C7-C0 Ausgang
        out     DDRD,akku       ; D7-D0 Ausgang
        rcall   rand            ; R27:R26:R25:R24 Startzahl
loop:   out     PORTA,r27       ; Ausgabe High-Byte
        out     PORTB,r26       ; Ausgabe Middle-High-Byte
        out     PORTC,r25       ; Ausgabe Middle-Low-Byte
        out     PORTD,r24       ; Ausgabe Low-Byte
        ldi     akku,10         ;
        rcall   wartex10ms      ; 100 ms warten
        rcall   random          ; R27:R26,R25,R24 neu mischen
        rjmp    loop            ;
        .INCLUDE  "random.asm"  ; neue Zufallszahl
        .INCLUDE  "rand.asm"    ; Startzahl
        .INCLUDE  "wartex10ms.asm" ; warte R16*10ms Symbol takt
        .EXIT                   ; Ende des Quelltextes

