

; k4p22.asm  ATmega8  Test des Analog/Digitalwandlers
; Port B: High-Teil des 10bit Analogwertes 
; Port C: PC0 ADC0 10 kOhm Potentiometer
; Port D: Low-Teil des 10bit Analogwertes 
; Konfiguration: interner Oszillator; externes Reset-Signal
        .INCLUDE "m8def.inc"     ; Deklarationen
        .DEF     akku = r16      ; Arbeitsregister
        .CSEG                    ; Programmsegment
         rjmp   start            ;
        .ORG    $13              ; keine Interrupts
start:  ldi     akku,LOW(RAMEND) ; Stapel anlegen
        out     SPL,akku         ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku         ;
        ldi     akku,$ff         ;
        out     DDRB,akku        ; Port B ist Ausgang
        out     DDRD,akku        ; Port D ist Ausgang
        ldi     akku,(0 << REFS1) | (0 << REFS0) | (0 << ADLAR) | 0;
        out     ADMUX,akku       ; Referenz, rechtsbndig, Kanal 0
        ldi     akku,(1 << ADEN) | (1 << ADSC) | (1 << ADPS1) | (1 << ADPS0);
        out     ADCSRA,akku      ; Wandler ein und starten, Einzel, Teiler 8
loop:   sbic    ADCSRA,ADSC      ; berspringe wenn Wandlung beendet
        rjmp    loop             ; warte auf Ende der Wandlung
        in      akku,ADCL        ; erst Low-Byte
        out     PORTD,akku       ; nach Port D
        in      akku,ADCH        ; dann High-Bits
        out     PORTB,akku       ; nach Port B
        sbi     ADCSRA,ADSC      ; Wandler neu starten
        rjmp    loop             ; Schleife
        .EXIT                    ; Ende des Quelltextes

