

; k4p10a.asm  ATmega8  Timer1 Test PWM-Betrieb
; Port B: PWM13 PWM12 PWM11 PWM10 COM1x1 OC1B OC1A COM1x0
; Port C: Eingabe High-Zeit Tastverhltnis
; Port D: Eingabe Frequenz  TOP         
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        sbi     DDRB,PB1        ; PB1 ist Ausgang OC1A
        sbi     DDRB,PB2        ; PB2 ist Ausgang OC1B
        ldi     akku,$C2        ; kalibrieren
        out     OSCCAL,akku     ; RC Oszillator
; Timer1 PWM programmieren 
        clr     akku            ; Steuerbits mit PINB einsetzen
        out     TCCR1A,akku     ; Steuerregister A Timer1
        ldi     akku,0b001      ; Taktteiler :1 Steuerbits mit PINB
        out     TCCR1B,akku     ; Steuerregister B Timer1 start
; Arbeitsschleife Steuerbits einsetzen
loop:   in      r17,PINB        ; WGM13 WGM12 WGM11 WGM10 X1 x x X0
        swap    r17             ; X1 x x X0 WGM13 WGM12 WGM11 WGM10 
        mov     r18,r17         ;
        andi    r18,0b00000011  ; 0 0 0 0 0 0 WGM11 WGM10
        sbrc    r17,7           ; berspringe wenn COM1x1 = 0
        ori     r18,0b10100000  ; COM1A1 = 1  COM1B1 = 1
        sbrc    r17,4           ; berspringe wenn COM1x0 = 0
        ori     r18,0b01010000  ; COM1A0 = 1  COM1B0 = 1
        in      akku,TCCR1A     ;
        or      akku,r18        ;
        out     TCCR1A,akku     ; 
        mov     r18,r17         ; X1 x x X0 WGM13 WGM12 WGM11 WGM10
        andi    r18,0b00001100  ; 0 0 0 0 WGM13 WGM12 0 0
        lsl     r18             ; 0 0 0 WGM13 WGM12 0 0 0
        in      akku,TCCR1B     ;
        or      akku,r18        ;
        out     TCCR1B,akku     ;
; OCR1A OCR1B ICR einsetzen
        in      akku,PINC       ; PINC: High-Zeit  High-Byte
        ldi     r17,$7F         ;                  Low-Byte
        out     OCR1AH,akku     ; Kanal A  
        out     OCR1AL,r17      ;       
        out     OCR1BH,akku     ; Kanal B
        out     OCR1BL,r17      ; 
        in      akku,PIND       ; PIND: Frequenz High-Byte
        ldi     r17,$7F         ;                   Low-Byte
        out     ICR1H,akku      ; TOP 
        out     ICR1L,r17       ;
        rjmp loop               ;
       .EXIT                    ; Ende des Quelltextes


