
 
; k2p24.asm ATmega8 Test der BCD-Arithmetik Siebensegmentausgabe
; Port B: BCD-Zhler 
; Port C: -
; Port D: Taste PD7: -1  Taste PD6: +1
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    eins = r17      ; fr Zhl-Eins
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        ldi     eins,1          ; Zhl-Eins
        clr     akku            ; Zhler lschen
; Arbeitsschleife
loop:   out     PORTB,akku      ; laufenden Zhler ausgeben
        sbis    PIND,PD7        ; berspringe wenn PD7 High
        rjmp    minus           ; PD7 Low: subtrahieren
        sbis    PIND,PD6        ; berspringe wenn PD6 High
        rjmp    plus            ; PD6 Low: addieren
        rjmp    loop            ; keine Taste
; PD7 gedrckt: Zhler - 1
minus:  sub     akku,eins       ; subtrahieren - 1 
        rcall   das             ; R16 korrigieren nach Subtraktion
minus1: sbis    PIND,PD7        ; berspringe wenn PD7 High
        rjmp    minus1          ; warte solange Taste Low
        rjmp    loop            ; Taste PD7 gelst: weiter
; PD6   gedrckt: Zhler + 1
plus:   add     akku,eins       ; addieren + 1
        rcall   daa             ; R16 korrigieren nach Addition
plus1:  sbis    PIND,PD6        ; berspringe wenn PD6 High
        rjmp    plus1           ; warte solange Taste Low
        rjmp    loop            ; Taste PD6 gelst: weiter
;
        .INCLUDE "daa.asm"      ; R16 korrigieren nach Addition
        .INCLUDE "das.asm"      ; R16 korrigieren nach Subtraktion
        .EXIT                   ; Ende des Quelltextes

