

; k2p18.asm ATmega8 Test der EEPROM-Adressierung
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
; Beim Start vorbesetzten Testwert $55 aus EEPROM ausgeben             *
        ldi     ZL,LOW(ekon)    ; Z <- EEPROM-Adresse der Konstanten   *
        ldi     ZH,HIGH(ekon)   ;                                      *
        cbi     EECR,EEWE       ; EEWE = 0: kein Schreiben             *
        rcall   reprom          ; R16 <- vorbesetzte Konstante         *
        out     PORTB,akku      ; LED-Ausgabe                          *
; Testschleife PIND -> EEPROM -> PORT B bei fallender Flanke PIND7     *
loop :  sbic    PIND,PIND7      ; warte                                *
        rjmp    loop            ; bis PIND7 Low                        *
        ldi     ZL,LOW(evar)    ; Z <- EEPROM-Adresse der Variablen    *
        ldi     ZH,HIGH(evar)   ;                                      *
        in      akku,PIND       ; Tasteneingabe PIND6 bis PIND0        *
        rcall   weprom          ; R16 -> EEPROM schreiben              *
        clr     akku            ; lschen fr Test                     *
        rcall   reprom          ; R16 <- EEPROM zurcklesen            *
        out     PORTB,akku      ; LED-Ausgabe                          *
warte:  sbis    PIND,PIND7      ; warte                                *
        rjmp    warte           ; bis PIND7 High                       *
        rjmp    loop            ;                                      *
; externe Unterprogramme fr EEPROM-Zugriff R16=Daten   Z=Adresse      *
       .INCLUDE "reprom.asm"    ; Read EEPROM                          *
       .INCLUDE "weprom.asm"    ; Write EEPROM                         *
;                                                                      *
; EEPROM-Bereich                                                       *
       .ESEG                    ; EEPROM-Segment                       *
ekon:  .DB       $55            ; vorbesetzte Konstante                *
evar:  .BYTE     1              ; Variable 1 Byte                      *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


