% Skript zweipunkt_32.m, in dem ein Zweipunktregler 
% mit Hysterese und verzgerter und nachgebender
% Rckfhrung untersucht wird. Arbeitet mit Modell
% zweipunkt32.mdl
clear;
% ------- Parameter des Reglers
Tt = 50;         % Zeitkonstante fr die Verzgerte-Wirkung
Th = 100;        % Zeitkonstante fr die Nachgebende-Wirkung
Kr = 15,         % Verstrkung der Rckfhrung
Ustell = 100;    % Faktor fr die Anregung       
hy = 2           % Relais Hysterese
ysoll = 0.5;     % Sollwert/1000
% ------ Prozess
T1 = 20;    T2 = 50;    T3 = 100; % Drei PT1-Glieder
Kp = 1;                           % bertragungsfaktor des Prozesses
Ksensor = 1/1000;                 % Sensor bertragungsfaktor
prozess = tf(Kp, conv(conv([T1,1],[T2,1]),[T3,1]));
[num, denum] = tfdata(prozess);
num = num{:};   denum = denum{:}; % Koeffizienten der
                                  % bertragungsfunktion des Prozesses
%------- Diskretisierung der Rckfhrungsglieder
sys_kTP = tf(1, [Tt,1]),          % Kontinuierliche Verzgerung
sys_kHP = tf([Th, 0],[Th,1]),     % Kontinuierliche Nachgebung

Ts = 0.5      % Abtastperiode
sys_dTP = c2d(sys_kTP, Ts),       % Diskrete Verzgerung
sys_dHP = c2d(sys_kHP, Ts),       % Diskrete Nachgebung
sys_rueck = Kr*sys_dTP*sys_dHP,   % Rckwirkung
%sys_rueck = Kr*sys_dTP,

[zaehl_rueck, nenner_rueck] = tfdata(sys_rueck); % Koeffizienten
zaehl_rueck = zaehl_rueck{:};     % des Zhlers und Nenners
nenner_rueck = nenner_rueck{:};   % der Rckfhrung

% ------- Aufruf der Simulation
Tfinal = 500;
sim('zweipunkt32',[0, Tfinal]);
xe = y.signals.values(:,1);       % Eingang
xa = y.signals.values(:,2);       % Ausgang Prozess
xr = y.signals.values(:,3);       % Ausgang Relais
xfeedback = y.signals.values(:,4);  % Rckfhrung
t = y.time;

figure(1);     clf;
subplot(311), plot(t, xe);
title('Sollwert fr den Ausgang');         grid on;
xlabel('Zeit in s');
La = axis;   axis([La(1:2), -ysoll*0.1/Ksensor,...
    ysoll*1.2/Ksensor]);
subplot(312), plot(t, xr, t, xfeedback*20);
title('Bipolare Steuerung des Prozesses und die Rckfhrung*20');     
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), La(3), 1.2*Ustell*10]);

subplot(313), plot(t, xa);
title('Ausgang des Prozesses (Istwert)');  grid on;
xlabel('Zeit in s');
