% Skript zweipunkt_31.m, in dem ein Zweipunktregler 
% mit Hysterese und verzgerter und nachgebender
% Rckfhrung untersucht wird. Arbeitet mit Modell
% zweipunkt31.mdl
clear;
% ------- Parameter des Reglers
Tt = 50;      % Zeitkonstante fr die Verzgerte-Wirkung
Th = 100;     % Zeitkonstante fr die Nachgebende-Wirkung
Kr = 2,       % Verstrkung der Rckfhrung
Ustell = 100;           hy = 4 % Relais Hysterese
ysoll = 500;
% ------ Prozess
T1 = 20;    T2 = 50;    T3 = 100; % Drei PT1-Glieder
Kp = 10;                          % bertragungsfaktor des Prozesses
% ------- Diskretisierung der Rckfhrungsglieder
sys_kTP = tf(1, [Tt,1]),          % Kontinuierliche Verzgerung
sys_kHP = tf([Th, 0],[Th,1]),     % Kontinuierliche Nachgebung
Ts = 0.1      % Abtastperiode
sys_dTP = c2d(sys_kTP, Ts),       % Diskrete Verzgerung
sys_dHP = c2d(sys_kHP, Ts),       % Diskrete Nachgebung
sys_rueck = Kr*sys_dTP*sys_dHP,   % Rckfhrung
%sys_rueck = Kr*sys_dTP,          % Rckfhrung nur mit TP-Filter 
[zaehl_rueck, nenner_rueck] = tfdata(sys_rueck); % Koeffizienten
zaehl_rueck = zaehl_rueck{:};     % des Zhlers und Nenners
nenner_rueck = nenner_rueck{:};   % der Rckfhrung

% ------- Aufruf der Simulation
Tfinal = 500;
sim('zweipunkt31',[0, Tfinal]);
xe = y.signals.values(:,1);       % Eingang
xa = y.signals.values(:,2);       % Ausgang Prozess
xr = y.signals.values(:,3);       % Ausgang Relais
xfeedback = y.signals.values(:,4);  % Rckfhrung
t = y.time;

figure(1);     clf;
subplot(311), plot(t, xe);
title('Sollwert fr den Ausgang');         grid on;
xlabel('Zeit in s');
La = axis;   axis([La(1:2), -ysoll*0.1,ysoll*1.2]);
subplot(312), plot(t, xr, t, xfeedback);
title('Ausgang des Relais und die Rckfhrung');     
xlabel('Zeit in s');    grid on;
%La = axis;   axis([La(1:2), -Ustell*0.1, Ustell*1.2]);
subplot(313), plot(t, xa);
title('Ausgang des Prozesses (Istwert)');  grid on;
xlabel('Zeit in s');
