% Skript zeipunkt_21.m, in dem eine Zweipunktregelung
% eines Prozesses mit drei Verzgerungen erster Ordnung 
% untersucht wird. Arbeitet mit Modell zweipunkt21.mdl
clear;
% -------- Parameter des Systems
Kp = 10;      % bertragungsfaktor des Prozesses
T1 = 100;     % Zeitkonstanten des Prozesses
T2 = 50;
T3 = 20;
hy = 0;       % Parameter der Hysterese 
Ustell = 100; % Stellgre fr Relais 'ON'
ysoll = 500;  % Sollwert
% -------- Aufruf der Simulation
Tfinal = 1000;      % Dauer der Simulation
dt = 0.1;
sim('zweipunkt21', [0:dt:Tfinal]);
y_soll = y.signals.values(:,1);
y_relais = y.signals.values(:,2);
y_ist = y.signals.values(:,3);
t = y.time;
figure(1);   clf;
subplot(211), plot(t, y_soll, t, y_ist);
title(['Soll- und Istwert (hy = ',num2str(hy),' )']);
grid on;   xlabel('Zeit in s');
La = axis; axis([La(1:2),-0.1*ysoll,1.2*ysoll]);

subplot(212), plot(t, y_relais);
title(['Ausgang des Relais (Ustell = ',num2str(Ustell),' )']);    
grid on;    xlabel('Zeit in s');
La = axis; axis([La(1:2),-0.1*Ustell,1.2*Ustell]);

