% Skript ss_zwei_eing_1.m, in dem ein Zustandsmodell mit 
% zwei Eingngen untersucht wird
% x' = Ax + Bu + Gw
% y =  Cx + Du + v   % Ein Ausgang
% E{ww} = xQx;   Ev^2 = R

clear;
H1 = tf(200, [1, 5, 100]);
sys1 = ss(H1);
A1 = sys1.a;    B1 = sys1.b;
C1 = sys1.c;    D1 = sys1.d;
sys2 = sys1(:,[1,1,1]);       % Ein Eingang fr u und zwei fr w
sys2.b(:,2:3) = eye(2,2);     % G = eyey(2,2);

% ------ Kalman-Filter
vnd = 0.01;            vny = 0.0001;
Q = eye(2,2)*vnd;      R = vny;
Kest = kalman(sys2, Q, R);
% -------- Aufruf der Simulation
Tfinal = 20;      dt = 0.01;
my_options = simset('Solver','ode45', 'MaxStep', dt);
sim('ss_zwei_eing1',[0,Tfinal],my_options);
t = y.time;                  % Simulationszeit
nt = length(t);
yr = y.signals.values(:,1);  % Korrekter Ausgang y(t)
yg = y.signals.values(:,2);  % Geschtzter Ausgang yg(t) 
xg= y.signals.values(:,:); % Geschtzte Zustandsvariablen des Prozesses
figure(1);    clf;
subplot(211), plot(t, yr, t, yg);
title(['Gemessener und geschtzter Ausgang ( vnd = ',num2str(vnd),...
    ' ; vny = ', num2str(vny),' )']);
xlabel('Zeit in s');   grid on;
nd = fix(nt/4);
n = nd:2*nd; 
subplot(212), plot(t(n), yr(n), t(n), yg(n));
title('Gemessener und geschtzter Ausgang (Ausschnitt)');
xlabel('Zeit in s');   grid on;
axis tight;
figure(2);    clf;
plot(t, xg);
title('Geschtzte Zustandsvariablen des Prozesses');
xlabel('Zeit in s');   grid on;

