% Skript regulator_1.m, in dem ein Regler mit einem Relais
% mit Hysterese und verzgerter und nachgebender Rckfhrung 
% untersucht wird.
clear;
% ------- Parameter des Regulators
hy = 2;       % Hysteresegre
Tp = 5;       % Zeitkonstante des Tiefpassfilters
Th = 500;     % Zeitkonstante des Hochpassfilters (praktisch nur TP)
Th = 10;      % Zuschalten des Hochpassfilters
Kr = 5;       % bertragungsfaktor in der Rckfhrung
Ustell = 10;  % Ausgang Relais fr Zustand 'ON'
% ------- Aufruf der Simulation
Ui = 5;       % Eingangswert (muss kleiner als Kr*Ustell sein)
Tfinal = 200; % Dauer der Simulation
dt = 0.1;
sim('regulator1', [0:dt:Tfinal]);
xa = y.signals.values(:,1);       % Ausgang Relais
xr = y.signals.values(:,2);       % Rckfhrung
xm = y.signals.values(:,3);       % Mittelwert des Ausgangs des Relais
t = y.time;
figure(1);   clf;
subplot(311), plot(t, xa);
title('Bipolarer Ausgang des Relais');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), -Ustell*0.1, Ustell*1.2]);
subplot(312), plot(t, xr);
title(['Rckfhrung fr Ui = ', num2str(Ui)]);
xlabel('Zeit in s');    grid on;
subplot(313), plot(t, xm);
title('Mittelwert des Ausgangs');
xlabel('Zeit in s');    grid on;