% Skript pol_41.m, in dem ein Servosystem mit Polplatzierung
% und I-Wirkung untersucht wird. Arbeitet mit Modell
% pol41.mdl
% Es wird eine Sttigung fr die Stellgre des Prozesses
% eingefhrt
clear;
% -------- Parameter des Systems
m1 = 10; m2 = 10; m3 = 5;
k1 = 10;   k2 = 1; 
c1 = 0.2;  c2 = 0.2; 
n = 6;     % Ordnung des Systems
A = [0 1 0 0 0 0;
    -k1/m1 -c1/m1 k1/m1 c1/m1 0 0;
    0 0 0 1 0 0;
    k1/m2 c1/m2 -(k1+k2)/m2 -(c1+c2)/m2 k2/m2 c2/m2;
    0 0 0 0 0 1;
    0 0 k2/m3 c2/m3 -k2/m3 -c2/m3];
B = [0 1 0 0 0 0]';
C = [0 0 0 0 1 0];
D = 0;
% ------- Polplatzierung
%p = [-1.25, -1.5, -2, -2.5, -3, -0.5+j*0.8, -0.5-j*0.8]; % Gewhlte Pole
p = [-1.25, -1.5, -2, -2.5, -3, -0.5+j*0.8, -0.5-j*0.8]*0.5; % Gewhlte Pole

% ------- Erweitertes Modell
An = [A, zeros(n,1); -C,0];   Bn = [B;0];
Kn = place(An, Bn, p);
K = Kn(1:n);       ki = -Kn(n+1);
% ------- Windup mit Back-Calculation
smax = 0.02;      % Sttigungspegel
Kr = 5;
% ------- Aufruf der Simulation
Tfinal = 50;      dt = 0.1;
my_options = simset('Solver','ode45','MaxStep',dt);
sim('pol41', [0, Tfinal], my_options);
xt = x.signals.values;
u = u.signals.values;
t = x.time;

figure(1);    clf;
subplot(211), plot(t, xt);
title('Sprungantwort des geregelten Prozesses');
xlabel('s');    grid on;
legend('x1','v1','x2','v2','x3','v3')
subplot(212), plot(t, u);
title('Begrenztes Steuerungssignal');
xlabel('s');    grid on;
La = axis;   axis([La(1:2), La(3:4)*1.2]);
