% Skript pol_4.m, in dem ein Servosystem mit Polplatzierung
% und I-Wirkung untersucht wird. Arbeitet mit Modell
% pol4.mdl
clear;
% -------- Parameter des Systems
m1 = 10; m2 = 10; m3 = 5;
k1 = 10;   k2 = 1; 
c1 = 0.2;  c2 = 0.2; 
n = 6;     % Ordnung des Systems
A = [0 1 0 0 0 0;
    -k1/m1 -c1/m1 k1/m1 c1/m1 0 0;
    0 0 0 1 0 0;
    k1/m2 c1/m2 -(k1+k2)/m2 -(c1+c2)/m2 k2/m2 c2/m2;
    0 0 0 0 0 1;
    0 0 k2/m3 c2/m3 -k2/m3 -c2/m3];
B = [0 1 0 0 0 0]';
C = [0 0 0 0 1 0];
D = 0;

figure(1);    clf;
my_sys = ss(A, B, C, D);    Tf = 50;
impulse(my_sys, Tf);
title('Impulsantwort des Prozesses');  xlabel('s'); grid on;

% ------- Polplatzierung
p = [-1, -2, -3, -4, -5, -0.5+j*0.8, -0.5-j*0.8]; % Gewhlte Pole
p = [-1.25, -1.5, -2, -2.5, -3, -0.5+j*0.8, -0.5-j*0.8]; % Gewhlte Pole
% ------- Erweitertes Modell
An = [A, zeros(n,1); -C,0];   Bn = [B;0];
Kn = place(An, Bn, p);
K = Kn(1:n);       ki = -Kn(n+1);

Tfinal = 20;      dt = 0.1;
my_options = simset('Solver','ode45','MaxStep',dt);
sim('pol4', [0, Tfinal], my_options);
xt = x.signals.values;
t = x.time;

figure(2);    clf;
plot(t, xt);
title('Zustandsvariablen des geregelten Prozesses');
xlabel('s');    grid on;
legend('x1','v1','x2','v2','x3','v3')
