% Skript pol_2.m, zur Untersuchung einer Polplatzierung. Arbeitet mit
% Modell pol2.mdl
clear;
% ------- Parameter des Systems
T1 = -5;      
T2 = 10;
p1 = -2+j*2;     p2 = conj(p1);   % Gewnschte Pole
% p1 = -1+j*2;     p2 = conj(p1);   % Gewnschte Pole
% ------- Rckkopplungen
a = real(p1);    b = imag(p1);
k1 = -2*a*T1-T1/T2-1;
k2 = (a^2 + b^2)*T1*T2-k1-1;

% ------- Aufruf der Simulation
Tfinal = 10;    dt = 0.1;
my_options = simset('Solver','ode45','MaxStep', dt);
sim('pol2',[0,Tfinal], my_options);

u = y.signals.values(:,1);
ya = y.signals.values(:,2);
t = y.time;

figure(1);   clf;
plot(t, u, t, ya);
title('Eingangssprung und Ausgang');
xlabel('Zeit in s');    grid on;
La = axis;    axis([La(1:3), 1.1*max(ya)]);