% Skript ohne_kalman_1.m, in dem das gleiche System
% ohne Kalman-Filter zum Vergleich mit PID-Regler
% geregelt wird

clear;
% -------- Modell des Prozesses
H11 = tf(100, [1, 5, 100]);
H12 = tf(1, [2, 1]);
H1 = H11*H12;
[b1,a1] = tfdata(H1);
b1 = b1{:};          a1 = a1{:};
% -------- Modell der Strung am Ausgang
H21 = tf(10, [1, 5, 10]);
H22 = tf(1, [3, 1]);
H2 = H21*H22;
[b2,a2] = tfdata(H2);
b2 = b2{:};          a2 = a2{:};
% -------- Prozess- und Messrauschen
vnd = 0.5;
vny = 0.01;
%vnd = 0;     % Zum Einstellen der PID-Parameter
%vny = 0;

% -------- PID-Regler
P = 1;     I = 0.5;     D = 1;
% -------- Aufruf der Simulation
Tfinal = 100;      dt = 0.01;
my_options = simset('Solver','ode45', 'MaxStep', dt);
sim('ohne_kalman1',[0,Tfinal],my_options);
t = y.time;      nt = length(t);
yist = y.signals.values(:,1);
ysoll = y.signals.values(:,2);

figure(1);   clf;
plot(t, [yist, ysoll]);
title('Istwert und Sollwert');
xlabel('Zeit in s');    grid on;


std(yist(1000:end))
