% Skript linear_fuellstnd_1.m, in dem die Linearisierung
% eines Dreitanksystems untersucht wird
clear;
% ------- Parameter des Systems
A1 =  0.02;    A2 = A1;      A3 = A1;   % Querschnitte der Tanks
A12 = 0.005;   A23 = A12;    A30 = A12; % Querschnitte der Verbindungen
h10 = 0.6;     h20 = 0.4;    h30 = 0.2; % Anfanfswerte der Fllstnde
      % fr Qz1 = 0.01 in fuellstnd_1
%h10 = 2.427;   h20 = 1.62;   h30 = 0.81; % Anfanfswerte der Fllstnde
      % fr Qz1 = 0.02 in fuellstnd_1
Qz  = 0.005,    
g = 9.89;

% ------- Faktoren der Durchflsse
q12= A12*sqrt(g/(2*(h10-h20)));
q23= A23*sqrt(g/(2*(h20-h30)));
q30= A30*sqrt(g/(2*(h30)));

% ------- Matrizen des Zustandsmodells
A = [-q12/A1, q12/A1, 0;
    q12/A2, -(q12+q23)/A2, q23/A2;
    0, q23/A3,-(q23+q30)/A3];
B = [1/A1;0;0];
C = [0, 0, 1];      D = 0;

% ------- Sprungantwort
my_system = ss(A, B, C, D);     % Linearisiertes System
tspr = 0:0.01:50;
[s3,t] = step(my_system, tspr);
h0 = [h10, h20, h30];           % Anfangsfllstnde
figure(1);     clf;
plot(t, s3*Qz);
title(['Antwort h3 auf Sprung  Qz = ',num2str(Qz),...
    '   ausgehend von  h0 = ',num2str(h0)]);
xlabel('Zeit in s');    grid on;
% ------- bertragungsfunktion
[b, a] = ss2tf(A,B,C,D,1),
zeit_konst = -1./roots(a),
verstaerk = b(4)*(zeit_konst(1)*zeit_konst(2)*zeit_konst(3)),