% Skript laufkatze_20.m, in dem eine PID-Regelung
% fr die Positionierung der Katze und Lastpendel
% untersucht wird. Arbeitet mit Modell laufkatze2.mdl
% Es wird eine Gleitreibung hinzugefgt.
clear;
% ------- Parameter des Systems
mk = 100;          % Masse Laufkatze
mL = 500;          % Masse Last
JL = 400;          % Trgheitsmoment der Last 
ls = 4;            % Lnge des Pendels
g = 9.89;          % Erdanziehungsbeschleunigung
mu = 0.01;          % Gleitreibungskoeffizient
% PID-Regler
P = 100;     I = 0;     D = 300;

% ------- Aufruf der Simulation
Tfinal = 100;       dt = 0.01;
xsoll = 10;
% my_options = simset('Solver', 'ode45', 'MaxStep', dt);
my_options = simset('Solver', 'ode4', 'FixedStep', dt);
sim('laufkatze20', [0,Tfinal], my_options);
x = y.signals.values(:,1);
phi = y.signals.values(:,2);
vx = y.signals.values(:,3);
t = y.time;

figure(1);   clf;
a(1) = subplot(211), plot(t, x, t, vx);
title('Lage und Geschwindigkeit der Laufkatze');    grid on;
xlabel('Zeit in s');

a(2) = subplot(212), plot(t, phi);
title('Winkel der Pendellast');    grid on;
xlabel('Zeit in s');
linkaxes(a,'x');