% Skript laufkatze_10.m, in dem eine Laufkatze mit Pendellast
% untersucht wird. Arbeitet mit Modell laufkatze10.mdl
% Die Differentialgleichungen wurde aus 
% http://www.tm-aktuell.de/TM5/Laufkatze/laufkatze_matlab.html
% bernommen. Es wird eine Gleitreibung hinzugefgt.
clear;
% ------- Parameter des Systems
mk = 100;          % Masse Laufkatze
mL = 500;          % Masse Last
JL = 400;          % Trgheitsmoment der Last 
ls = 4;            % Lnge des Pendels
F0 = 2000;         % Kraftsto
dft = 0.1;         % Prozent von Tfinal  als Dauer des Stoes
g = 9.89;
mu = 0.01;          % Gleitreibungskoeffizient
% ------- Aufruf der Simulation
Tfinal = 100;
dt = 0.01;

%my_options = simset('Solver', 'ode45', 'MaxStep', dt);
my_options = simset('Solver', 'ode4', 'FixedStep', dt);
sim('laufkatze10', [0,Tfinal], my_options);

x = y.signals.values(:,1);
phi = y.signals.values(:,2);
t = y.time;

figure(1);   clf;
a(1) = subplot(211), plot(t, x);
title('Lage der Laufkatze');    grid on;
xlabel('Zeit in s');

a(2) = subplot(212), plot(t, phi);
title('Winkel der Pendellast');    grid on;
xlabel('Zeit in s');
linkaxes(a,'x');