% Skript fuellstnd_3.m, in dem die Regelung des
% Fllstandes in eines System mit drei Tanks
% untersucht wird. Arbeitet mit Modell fuellstnd3.mdl 
clear;
% ------- Parameter des Systems
A1 =  0.02;    A2 = A1;      A3 = A1;   % Querschnitte der Tanks
A12 = 0.005;   A23 = A12;    A30 = A12; % Querschnitte der Verbindungen
h10 = 0.0;     h20 = h10;    h30 = h10; % Anfanfswerte der Fllstnde
g = 9.89;
Tp = 0.1;      % Zeitkonstante der Pumpe
Qz = 0.05,     % Durchfluss der Pumpe
% ------- Parameter des Zweipunkt-Reglers mit verzgerter 
% und nachgebender Rckfhrung
Tt = 2;         % Zeitkonstante fr die Verzgerte-Wirkung
Th = 1;        % Zeitkonstante fr die Nachgebende-Wirkung
Kr = 10,         % Verstrkung der Rckfhrung
Usoll = 0.2,     % Sollwert fr Fllstand im Tank 3
hy = 0.01           % Relais Hysterese
% Diskretisierung der Rckfhrungsglieder
sys_kTP = tf(1, [Tt,1]),          % Kontinuierliche Verzgerung
sys_kHP = tf([Th, 0],[Th,1]),     % Kontinuierliche Nachgebung

Ts = 0.001      % Abtastperiode
sys_dTP = c2d(sys_kTP, Ts),       % Diskrete Verzgerung
sys_dHP = c2d(sys_kHP, Ts),       % Diskrete Nachgebung
sys_rueck = Kr*sys_dTP*sys_dHP,   % Rckwirkung
%sys_rueck = Kr*sys_dTP,

[zaehl_rueck, nenner_rueck] = tfdata(sys_rueck); % Koeffizienten
zaehl_rueck = zaehl_rueck{:};     % des Zhlers und Nenners
nenner_rueck = nenner_rueck{:};   % der Rckfhrung

% ------- Aufruf der Simulation
Tfinal = 50;
dt = 0.001;
sim('fuellstnd3', [0:dt:Tfinal]);
h1 = y.signals.values(:,1);
h2 = y.signals.values(:,2);
h3 = y.signals.values(:,3);
t = y.time;

figure(1);   clf;
plot(t, [h1, h2, h3]);
legend('h1', 'h2', 'h3');   grid on;
