% Skript fuellstnd_2.m, in dem die Regelung des
% Fllstandes in eines System mit drei Tanks
% untersucht wird. Arbeitet mit Modell fuellstnd2.mdl 
clear;
% ------- Parameter des Systems
A1 =  0.02;    A2 = A1;      A3 = A1;   % Querschnitte der Tanks
A12 = 0.005;   A23 = A12;    A30 = A12; % Querschnitte der Verbindungen
h10 = 0.0;     h20 = h10;    h30 = h10; % Anfanfswerte der Fllstnde
g = 9.89;
Tp = 1;        % Zeitkonstante der Pumpe
% ------- Parameter des PID-Reglers
%P = 0.3;     I = 0;        D = 0;       % Parameter fr die Bestimmung
            % von Vkrit und Tkrit 
Vkrit = 0.15;      Tkrit = 8;
P = Vkrit*0.6;    I = P/(0.5*Tkrit);    D = 0.6*0.12*Vkrit*Tkrit;
%Usoll = 0.1,
Usoll = 0.2,
Usoll = 0.4,
% ------- Aufruf der Simulation
Tfinal = 50;   dt = 0.001;
sim('fuellstnd2', [0:dt:Tfinal]);
h1 = y.signals.values(:,1);
h2 = y.signals.values(:,2);
h3 = y.signals.values(:,3);
t = y.time;
%
figure(1);   clf;
plot(t, [h1, h2, h3]);
legend('h1', 'h2', 'h3');   grid on;
title(['Fllstnde fr Usoll = ',num2str(Usoll)])