% Skript fuellstnd_1.m, in dem ein System mit drei Tanks
% untersucht wird. Arbeitet mit Modell fuellstnd1.mdl 
clear;
global s_ist t
% ------- Parameter des Systems
A1 =  0.02;    A2 = A1;      A3 = A1;   % Querschnitte der Tanks
A12 = 0.005;   A23 = A12;    A30 = A12; % Querschnitte der Verbindungen
h10 = 0.0;     h20 = h10;    h30 = h10; % Anfanfswerte der Fllstnde

Qz1 = 0.01,     % Sprung bei t = 0
%Qz1 = 0.02,     % Sprung bei t = 0
%Qz1 = 0.04,     % Sprung bei t = 0

Qz  = 0.005,    % Sprung bei t = 100
%Qz  = 0.001,    % Sprung bei t = 100
g = 9.89;
% ------- Aufruf der Simulation
Tfinal = 200;      dt = 0.001;
sim('fuellstnd1', [0:dt:Tfinal]);
h1 = y.signals.values(:,1);
h2 = y.signals.values(:,2);
h3 = y.signals.values(:,3);
t = y.time;        nt = length(t),
figure(1);   clf;
plot(t, [h1, h2, h3]);title('Fllstnde');
xlabel('Zeit in s');     
legend('h1', 'h2', 'h3');   grid on;
% ------- Die Sprungantwort relativ zum stationren Zustand
s_ist = h3((nt-1)/2:end)-h3((nt-1)/2-2);
t = (0:nt-((nt-1)/2))*dt;
% ------- Identifikation eines System bestehnd aus drei PT1-Glieder
disp('Bitte Warten !!!')
p = fminsearch(@sprung_1, [0.1 1 2 3]);
p1 = p;
p1(1) = p(1)/Qz;
p1,
figure(2);   clf;    
plot((0:nt-((nt-1)/2))*dt, [s_ist, sprung(p, (0:nt-((nt-1)/2))*dt)]);
title('Gemessene und angepasste Sprungantwort');
xlabel('Zeit in s');     grid on;
legend('Gemessene', 'Angepasste');