% Skript beobachter_22.m, in dem ein Servosystem mit 
% Beobachter und Polplatzierung untersucht wird. 
% Arbeitet mit Modell beobachter22.mdl
clear;
% -------- Parameter des Systems
m1 = 10; m2 = 10; m3 = 5;
k1 = 10;   k2 = 1;    k3 = 10;
c1 = 0.5;  c2 = 0.5; 
n = 6;     % Ordnung des Systems
A = [0 1 0 0 0 0;
    -(k1+k3)/m1 -c1/m1 k1/m1 c1/m1 k3/m1 0;
    0 0 0 1 0 0;
    k1/m2 c1/m2 -(k1+k2)/m2 -(c1+c2)/m2 k2/m2 c2/m2;
    0 0 0 0 0 1;
    k3/m3 0 k2/m3 c2/m3 -(k2+k3)/m3 -c2/m3];
B = [0 1 0 0 0 0]';         C = [0 0 0 0 1 0];         D = 0;
% ------- Beobachter Entwicklung mit 6 Pole
p = [-1.25, -1.5, -2, -2.5, -1+j*0.8,...
    -1-j*0.8];                    % Gewhlte Pole
Ke = (place(A',C',p))';
x0 = [0.1,0,0.1,0,0.3,0];     % Anfangszustnde des Prozesses
%x0 = [0,0,0,0,0,0];     % Anfangszustnde des Prozesses
% ------- Polplatzierung der 7 Pole des Sevosystems
p = [-0.5, -0.6, -0.7, -0.8, -0.9, -0.5+j*0.8,...
    -0.5-j*0.8]; % Gewhlte Pole
An = [A, zeros(n,1); -C,0];   Bn = [B;0];
Kn = place(An, Bn, p);
K = Kn(1:n);       ki = -Kn(n+1);
smax = 0.05;       % Begrenzung fr den Sttigungsblock
Kr =5;              % Anti-Windup Parameter
% ------- Aufruf der Simulation
Tfinal = 100;      dt = 0.01;
my_options = simset('Solver','ode45','MaxStep',dt);
sim('beobachter22', [0, Tfinal], my_options);
y = yx.signals.values(:,1);       % Ausgang des Prozesses
xg = yx.signals.values(:,2:7);   % Geschtzte Zustandsvariablen 
us = us.signals.values;           % Begrenzte Stellungsgre
t = yx.time;
figure(1);    clf;
subplot(211), plot(t, y);
  title(['Sprungantwort mit Anfangsbedingungen']);
  xlabel('s');    grid on;
subplot(212), plot(t, xg);
  title('Geschtzte Zustandsvariablen x0g = 0');
  xlabel('s');    grid on;
  legend('x1g','v1g','x2g','v2g','x3g','v3g')
Q = std(y);         % Gtemass
figure(2);    clf;
subplot(211), plot(t, y);
  title(['Sprungantwort mit Anfangsbedingungen']);
  xlabel('s');    grid on;
subplot(212), plot(t, us);
  title('Begrenzte Stellungsgre');
  xlabel('s');    grid on;
La = axis;    axis([La(1:2),La(3:4)*1.2]);

