% Skript aktiv_tilger_2.m

clear;
s = tf('s');
% -------- Parameter des Systems
m1 = 100;     k1 = 5;     c1 = 1;
m2 = 5;      
k2 = 10,      c2 = 10;  
fsig = 2;

% -------- Analyse des Systems
Ai = [m1*s^2+(c1+c2)*s + (k1+k2),   -(c2*s+k2);
    -(c2*s+k2), m2*s^2+c2*s+k2];
Bi = [1,0;0,1];

H = inv(Ai)*Bi;
H = minreal(H);
[b11, a11] = tfdata(H(1,1));   [b12, a12] = tfdata(H(1,2));
[b21, a21] = tfdata(H(2,1));   [b22, a22] = tfdata(H(2,2));

b11 = b11{:};    a11 = a11{:};
b12 = b12{:};    a12 = a12{:};

b21 = b21{:};    a21 = a21{:};
b22 = b22{:};    a22 = a22{:};
Kr = 2000;        % Rckfhrungsfaktor
%Kr = 0;          % Ohne Rckfhrung
Hr = Kr*s/(0.01*s+1);  % bertragungsfunktion der Rckfhrung

Hsys = feedback(1, Hr*H(1,2))*H(1,1); % bertragungsfunktion von
Hsys = minreal(Hsys);           % Strung bis Lage der Masse 1
[bsys, asys] = tfdata(Hsys);
bsys = bsys{:},    asys = asys{:},
roots(asys),

% -------- Aufruf der Simulation
Tfinal = 1000;
dt = 0.01;
sim('aktiv_tilger2', [0:dt:Tfinal]);
t = y.time;
y11 = y.signals.values(:,1);
y12 = y.signals.values(:,2);
y1 = y.signals.values(:,3);

Q = std(y1),

figure(1);    clf;
subplot(311), plot(t,y11);
title('Koordinate y11');
xlabel('Zeit in s');    grid on;
subplot(312), plot(t,y11,t,y12);
title('Koordinate y11 und y12');
xlabel('Zeit in s');    grid on;
subplot(313), plot(t,y1);
title('Koordinate y1 = y11+y12');
xlabel('Zeit in s');    grid on;
