% Skript aktiv_tilger_1.m, in dem eine aktive Tilgung
% untersucht wird. Arbeitet mit Modell aktiv_tilger1.mdl
clear;
% -------- Parameter des Systems
m1 = 200;      k1 = 100;     c1 = 20;
f1 = sqrt(k1/m1)/(2*pi),    % Eigenfrequenz ohne Dmpfung
m2 = 1;       k2 = 10;      c2 = 10;
f2 = sqrt(k2/m2)/(2*pi),    % Eigenfrequenz ohne Dmpfung
fsig = 0.01;     % Frequenz der Anregung Fe1
Fe1 = 0.5;     % Amplitude der Anregung
% -------- Regler mit Rckfhrung von a1 
P = 0;       I = 2000;     D = 0; % Mit Regler (aktive Tilgung)
%P = 0;       I = 0;     D = 0;     % Ohne Regler 
% -------- Aufruf der Simulation
Tfinal = 2000;     dt = 0.01;
sim('aktiv_tilger1', [0:dt:Tfinal]);
t = y.time;
y1 = y.signals.values(:,1);
y2 = y.signals.values(:,2);
Fe1_t = f.signals.values(:,1);  % Anregungskraft
Fe2_t = f.signals.values(:,2);
% -------- Fr die Darstellung von 10 Perioden 
%          im stationren Zustand
nt = length(t);         nd = 1:nt; 
Tdarst = 10/fsig;       ndarst = fix(Tdarst/dt);
if ndarst <= nt
     nd = nt - ndarst : nt;
else nd = 1:nt;
end;
Q = std(y1(nd)),      % Gutefunktion
figure(1);    clf;
subplot(311), plot(t(nd),y1(nd));
  title(['Koordinate y1(t) fr fsig = ',num2str(fsig), ' Hz'])
  xlabel('Zeit in s');      grid on;
subplot(312), plot(t(nd),y2(nd));
  title(['Koordinate y2(t)'])
  xlabel('Zeit in s');      grid on;
subplot(313), plot(t(nd),y1(nd),t(nd),y2(nd));
  title(['Koordinate y1(t) und y2(t)'])
  xlabel('Zeit in s');      grid on;
figure(2);    clf;
plot(t(nd),Fe1_t(nd),t(nd),Fe2_t(nd));
  title(['Anregungs- und Rckfhrungskraft (Fe1, Fe2) fr fsig = ',...
      num2str(fsig), ' Hz']);
  xlabel('Zeit in s');      grid on;
  legend('Fe1', 'Fe2')

