% Skript PID_windup1.m, in dem zwei Lsungen der Anti-
% WindUp Thematik untersucht werden. Arbeitet mit den
% Simulink-Modellen PID_windup_1.mdl und PID_windup_11.mdl
clear;
% ------- Parameter des Systems 3. Ordnung
T1 = 1;    k1 = 1;
T2 = 5;    k2 = 1;
T3 = 10;   k3 = 10;
H1 = tf(k1,[T1, 1]);     H2 = tf(k2,[T2, 1]);
H3 = tf(k3,[T3, 1]);
H = H1*H2*H3;
[b,a] =tfdata(H);     b = b{:};    a = a{:};
% PID-Regler;
P = 3;    I = 0.5;     D = 4;
b = 1;    c = 0;
smax = 0.3;      smin = -0.3;  % Begrenzungen der Stellgre
% ------- Aufruf der Simulation fr die erste Lsung 
% ('clamping')
Tfinal = 50;      dt = 0.01;
my_options = simset('Solver','ode45','MaxStep', dt);
sim('PID_windup_1',[0,Tfinal], my_options);
t = y.time;
ya = y.signals.values(:,1);    % Antwort des Systems
ys = y.signals.values(:,2);    % Ausgang des PID-Reglers
figure(1);     clf;
subplot(211); plot(t,ya);
title('Sprungantwort des Systems');
xlabel('Zeit in s');   grid on;
subplot(212); plot(t,ys);
title('Ausgang des PID-Reglers mit Begrenzung (Stellgre)');
xlabel('Zeit in s');   grid on;
La = axis;    axis([La(1:2),smin*1.2, smax*1.2]);
% ------- Aufruf der Simulation fr die zweite Lsung 
% ('back-calculation')
Kb = 0.25;  
my_options = simset('Solver','ode45','MaxStep', dt);
sim('PID_windup_11',[0,Tfinal], my_options);
t = y.time;
ya = y.signals.values(:,1);    % Antwort des Systems
ys = y.signals.values(:,2);    % Ausgang des PID-Reglers
figure(2);     clf;
subplot(211); plot(t,ya);
title('Sprungantwort des Systems');
xlabel('Zeit in s');   grid on;
subplot(212); plot(t,ys);
title('Ausgang des PID-Reglers mit Begrenzung (Stellgre)');
xlabel('Zeit in s');   grid on;
La = axis;    axis([La(1:2),smin*1.2, smax*1.2]);
