% Skript sepic2.m, in dem das Modell
% sepic_2.mdl initialisiert und aufgerufen wird
clear;
% -------- Parameter der Schaltung
R = 5;           L1 = 0.00005;     
L2 = L1;
M = 0.8*L1;     
C1 = 100e-6;     C2 = C1;
Ui = 5;
f0 = 50e3;       T = 1/f0;      
%T2 = T*0.5;
T2 = T*0.2,
T1 = T-T2;

f2 = sqrt(1/(L2*C2))/(2*pi),
% -------- Aufruf der Simulation
Tfinal = 0.1,      dt = 1e-6;
sim('sepic_2',[0:dt:Tfinal]);

t = y.time;
iL1 = y.signals.values(:,1);
uc2 = y.signals.values(:,2);
iL2 = y.signals.values(:,3);
uc1 = y.signals.values(:,4);   % Ausgangsspannung

figure(1);     clf;
n = length(t);
subplot(411), plot(t, iL1);
axis tight;  grid on;
title('Strom der Induktivitt L1  iL1(t)');
xlabel('Zeit in s');
subplot(412), plot(t, uc2);
axis tight;  grid on;
title('Spannung der Kapazitt C2  uc2(t)');
xlabel('Zeit in s');
subplot(413), plot(t, iL2);
axis tight;  grid on;
title('Strom der Induktivitt L2  iL2(t)');
xlabel('Zeit in s');
subplot(414), plot(t, uc1);
axis tight;  grid on;
title('Spannung der Kapazitt C1  uc1(t)  (Ausgangsspannung)');
xlabel('Zeit in s');

figure(2);     clf;
nd = n-200;
subplot(411), plot(t(nd:end), iL1(nd:end));
axis tight;  grid on;
title('Strom der Induktivitt L1  iL1(t)');
xlabel('Zeit in s');
subplot(412), plot(t(nd:end), uc2(nd:end));
axis tight;  grid on;
title('Spannung der Kapazitt C2  uc2(t)');
xlabel('Zeit in s');
subplot(413), plot(t(nd:end), iL2(nd:end));
axis tight;  grid on;
title('Strom der Induktivitt L2  iL2(t)');
xlabel('Zeit in s');
subplot(414), plot(t(nd:end), uc1(nd:end));
axis tight;  grid on;
title('Spannung der Kapazitt C1  uc1(t)  (Ausgangsspannung)');
xlabel('Zeit in s');

% -------- Geschtzte Leistung am Eingang und Ausgang
nsch = fix(n/2);              
Pa = mean(uc1(nsch:end).^2)/R, % Werte uc1 iL1 ohne Einschwingen
Pi = mean(iL1(nsch:end))*Ui,








