% Skript lock_in01.m in dem ein Lock-In-Verstrker simuliert
% wird. Arbeitet mit Modell lock_in_01.mdl
clear;
% ------- Parameter des Systems
fsig = 10e3;       % Frequenz des Nutzsignals
Usig = 1000e-9;      % Effektivwert des Nutzsignals
ampl_sig = Usig*sqrt(2);   % Amplitude des Nutzsignals
phase_sig = 0;     % Nullphase
ampl_ref = 1;      % Amplitude des Referenzsignals
phase_ref = 0;     % Nullphase
A = 1000;          % Verstrkung des Verstrkers
Ts = 1e-5;         % Abtastperiode
fs = 1/Ts;         % Abtastfrequenz
rausch_effektiv = 5e-9;  % Spektraler Effektivwert 
                   % des Rauschens nV/sqrt(Hz)
v_rausch = (rausch_effektiv)^2*fs;  % Varianz des Rauschsignals

% Impulsantwort des FIR-Dezimierungsfilters
L = 100;           % Dezimierungsfaktor fr eine Stufe
nord = 5;        % Ordnung des IIR-TP-Filters
[b,a] = butter(nord, 1/L); % Impulsantwort des IIR-Filters
%return
% ------- Aufruf der Simulation
Tfinal = 10;
dt = Ts;
ts = [0,Tfinal-Ts];
my_options = simset('Solver', 'FixedStepDiscrete','FixedStep',...
    dt);
sim('lock_in_01', ts, my_options);
sig_rausch = y.signals.values(:,1);
ausgang = y.signals.values(:,2);
t = y.time;

figure(1);    clf,
a(1) = subplot(211), plot(t, sig_rausch);
title('Signal plus Rauschen');   grid on;
xlabel('Zeit in s');
a(2) = subplot(212), plot(t, ausgang);
title('Ausgang des Lock-In-Verstrkers');   grid on;
xlabel('Zeit in s');
linkaxes(a, 'x');

% ------ Varianz des Ausgangssignals
ns = length(ausgang)
nd = fix(ns/12);
ausgang = ausgang(nd:end);   % Ohne Einschwingen
mittelwert_ausgang = mean(ausgang),
varianz_ausgang = std(ausgang)^2,
v_ausgang = mean((ausgang-mittelwert_ausgang).^2),

geschaetzte_varianz = (v_rausch*(A^2)*(ampl_ref^2)/2)/(L^2),














